/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.LogMarker;

public class BufferingLogger
extends StringLogger {
    private final Queue<LogMessage> buffer = new ConcurrentLinkedQueue<LogMessage>();

    private void log(String msg, Throwable cause, boolean flush, LogMarker logMarker, Level level) {
        this.buffer.add(new LogMessage(msg, cause, flush, logMarker, level));
    }

    @Override
    protected void doDebug(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        this.log(msg, cause, flush, logMarker, Level.DEBUG);
    }

    @Override
    public void info(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        this.log(msg, cause, flush, logMarker, Level.INFO);
    }

    @Override
    public void warn(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        this.log(msg, cause, flush, logMarker, Level.WARN);
    }

    @Override
    public void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
        this.log(msg, cause, flush, logMarker, Level.ERROR);
    }

    @Override
    public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, boolean flush) {
        source.visit(new StringLogger.LineLoggerImpl(this));
    }

    @Override
    public void addRotationListener(Runnable listener) {
    }

    @Override
    protected void logLine(String line) {
        this.info(line);
    }

    @Override
    public void flush() {
        this.info("", true);
    }

    @Override
    public void close() {
    }

    public void replayInto(StringLogger other) {
        LogMessage message;
        block6: while ((message = this.buffer.poll()) != null) {
            switch (message.level) {
                case DEBUG: {
                    other.debug(message.message, message.throwable, message.flush, message.logMarker);
                    continue block6;
                }
                case INFO: {
                    other.info(message.message, message.throwable, message.flush, message.logMarker);
                    continue block6;
                }
                case WARN: {
                    other.warn(message.message, message.throwable, message.flush, message.logMarker);
                    continue block6;
                }
                case ERROR: {
                    other.error(message.message, message.throwable, message.flush, message.logMarker);
                    continue block6;
                }
            }
            throw new IllegalStateException("Unknown log level " + (Object)((Object)message.level));
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter sb = new PrintWriter(stringWriter);
        for (LogMessage message : this.buffer) {
            sb.println(message.message);
            if (message.throwable == null) continue;
            message.throwable.printStackTrace(sb);
        }
        return stringWriter.toString();
    }

    private static class LogMessage {
        private final String message;
        private final Throwable throwable;
        private final boolean flush;
        private final LogMarker logMarker;
        private final Level level;

        public LogMessage(String message, Throwable throwable, boolean flush, LogMarker logMarker, Level level) {
            this.message = message;
            this.throwable = throwable;
            this.flush = flush;
            this.logMarker = logMarker;
            this.level = level;
        }
    }

    private static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

