/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;

public interface SecurityContext {
    public static final SecurityContext AUTH_DISABLED = new AuthDisabled(AccessMode.Static.FULL);

    public AccessMode mode();

    public AuthSubject subject();

    public boolean isAdmin();

    public SecurityContext freeze();

    public SecurityContext withMode(AccessMode var1);

    default public String description() {
        return String.format("user '%s' with %s", this.subject().username(), this.mode().name());
    }

    default public String defaultString(String name) {
        return String.format("%s{ username=%s, accessMode=%s }", name, this.subject().username(), this.mode());
    }

    public static final class Frozen
    implements SecurityContext {
        private final AuthSubject subject;
        private final AccessMode mode;

        public Frozen(AuthSubject subject, AccessMode mode) {
            this.subject = subject;
            this.mode = mode;
        }

        @Override
        public AccessMode mode() {
            return this.mode;
        }

        @Override
        public AuthSubject subject() {
            return this.subject;
        }

        @Override
        public boolean isAdmin() {
            return true;
        }

        @Override
        public SecurityContext freeze() {
            return this;
        }

        @Override
        public SecurityContext withMode(AccessMode mode) {
            return new Frozen(this.subject, mode);
        }
    }

    public static final class AuthDisabled
    implements SecurityContext {
        private final AccessMode mode;

        private AuthDisabled(AccessMode mode) {
            this.mode = mode;
        }

        @Override
        public AccessMode mode() {
            return this.mode;
        }

        @Override
        public AuthSubject subject() {
            return AuthSubject.AUTH_DISABLED;
        }

        @Override
        public boolean isAdmin() {
            return true;
        }

        public String toString() {
            return this.defaultString("auth-disabled");
        }

        @Override
        public String description() {
            return "AUTH_DISABLED with " + this.mode.name();
        }

        @Override
        public SecurityContext freeze() {
            return this;
        }

        @Override
        public SecurityContext withMode(AccessMode mode) {
            return new AuthDisabled(mode);
        }
    }
}

