/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.NoSuchElementException;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.storageengine.api.RelationshipItem;

public class CursorRelationshipIterator
implements RelationshipIterator,
Resource {
    private Cursor<RelationshipItem> cursor;
    private boolean hasNext;
    private long id;
    private int type;
    private long startNode;
    private long endNode;

    public CursorRelationshipIterator(Cursor<RelationshipItem> resourceCursor) {
        this.cursor = resourceCursor;
        this.hasNext = this.nextCursor();
    }

    private boolean nextCursor() {
        if (this.cursor != null) {
            boolean hasNext = this.cursor.next();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }
        return false;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next() {
        if (this.hasNext) {
            try {
                RelationshipItem item = (RelationshipItem)this.cursor.get();
                this.id = item.id();
                this.type = item.type();
                this.startNode = item.startNode();
                this.endNode = item.endNode();
                long l = item.id();
                return l;
            }
            finally {
                this.hasNext = this.nextCursor();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
        visitor.visit(this.id, this.type, this.startNode, this.endNode);
        return false;
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }
}

