/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.Mode;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.FieldInjections;
import org.neo4j.kernel.impl.proc.MethodSignatureCompiler;
import org.neo4j.kernel.impl.proc.OutputMappers;
import org.neo4j.kernel.impl.proc.ProcedureAllowedConfig;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class ReflectiveProcedureCompiler {
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final OutputMappers outputMappers;
    private final MethodSignatureCompiler inputSignatureDeterminer;
    private final FieldInjections fieldInjections;
    private final Log log;
    private final TypeMappers typeMappers;
    private final ProcedureAllowedConfig config;

    public ReflectiveProcedureCompiler(TypeMappers typeMappers, ComponentRegistry components, Log log, ProcedureAllowedConfig config) {
        this.inputSignatureDeterminer = new MethodSignatureCompiler(typeMappers);
        this.outputMappers = new OutputMappers(typeMappers);
        this.fieldInjections = new FieldInjections(components);
        this.log = log;
        this.typeMappers = typeMappers;
        this.config = config;
    }

    public List<CallableUserFunction> compileFunction(Class<?> fcnDefinition) throws KernelException {
        try {
            List procedureMethods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserFunction.class)).collect(Collectors.toList());
            if (procedureMethods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(fcnDefinition);
            ArrayList<CallableUserFunction> out = new ArrayList<CallableUserFunction>(procedureMethods.size());
            for (Method method : procedureMethods) {
                out.add(this.compileFunction(fcnDefinition, constructor, method));
            }
            out.sort((a, b) -> a.signature().name().toString().compareTo(b.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile function defined in `%s`: %s", fcnDefinition.getSimpleName(), e.getMessage());
        }
    }

    public List<CallableProcedure> compileProcedure(Class<?> procDefinition) throws KernelException {
        try {
            List procedureMethods = Arrays.stream(procDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Procedure.class)).collect(Collectors.toList());
            if (procedureMethods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(procDefinition);
            ArrayList<CallableProcedure> out = new ArrayList<CallableProcedure>(procedureMethods.size());
            for (Method method : procedureMethods) {
                out.add(this.compileProcedure(procDefinition, constructor, method));
            }
            out.sort((a, b) -> a.signature().name().toString().compareTo(b.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile procedure defined in `%s`: %s", procDefinition.getSimpleName(), e.getMessage());
        }
    }

    private ReflectiveProcedure compileProcedure(Class<?> procDefinition, MethodHandle constructor, Method method) throws ProcedureException, IllegalAccessException {
        String valueName = method.getAnnotation(Procedure.class).value();
        String definedName = method.getAnnotation(Procedure.class).name();
        QualifiedName procName = this.extractName(procDefinition, method, valueName, definedName);
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        OutputMappers.OutputMapper outputMapper = this.outputMappers.mapper(method);
        MethodHandle procedureMethod = this.lookup.unreflect(method);
        List<FieldInjections.FieldSetter> setters = this.fieldInjections.setters(procDefinition);
        Optional<String> description = this.description(method);
        Procedure procedure = method.getAnnotation(Procedure.class);
        Mode mode = this.mode(procedure.mode());
        if (method.isAnnotationPresent(PerformsWrites.class)) {
            if (!procedure.mode().equals((Object)org.neo4j.procedure.Mode.DEFAULT)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Conflicting procedure annotation, cannot use PerformsWrites and mode", new Object[0]);
            }
            mode = Mode.READ_WRITE;
        }
        Optional<String> deprecated = this.deprecated(method, procedure::deprecatedBy, "Use of @Procedure(deprecatedBy) without @Deprecated in " + procName);
        ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputMapper.signature(), mode, deprecated, this.config.rolesFor(procName.toString()), description);
        return new ReflectiveProcedure(signature, constructor, procedureMethod, outputMapper, setters);
    }

    private ReflectiveUserFunction compileFunction(Class<?> procDefinition, MethodHandle constructor, Method method) throws ProcedureException, IllegalAccessException {
        String definedName;
        String valueName = method.getAnnotation(UserFunction.class).value();
        QualifiedName procName = this.extractName(procDefinition, method, valueName, definedName = method.getAnnotation(UserFunction.class).name());
        if (procName.namespace() == null || procName.namespace().length == 0) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "It is not allowed to define functions in the root namespace please use a namespace, e.g. `@UserFunction(\"org.example.com.%s\")", procName.name());
        }
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        Class<?> returnType = method.getReturnType();
        TypeMappers.NeoValueConverter valueConverter = this.typeMappers.converterFor(returnType);
        MethodHandle procedureMethod = this.lookup.unreflect(method);
        List<FieldInjections.FieldSetter> setters = this.fieldInjections.setters(procDefinition);
        Optional<String> description = this.description(method);
        UserFunction function = method.getAnnotation(UserFunction.class);
        Optional<String> deprecated = this.deprecated(method, function::deprecatedBy, "Use of @UserFunction(deprecatedBy) without @Deprecated in " + procName);
        UserFunctionSignature signature = new UserFunctionSignature(procName, inputSignature, valueConverter.type(), deprecated, this.config.rolesFor(procName.toString()), description);
        return new ReflectiveUserFunction(signature, constructor, procedureMethod, valueConverter, setters);
    }

    private Optional<String> deprecated(Method method, Supplier<String> supplier, String warning) {
        String deprecatedBy = supplier.get();
        Optional<String> deprecated = Optional.empty();
        if (method.isAnnotationPresent(Deprecated.class)) {
            deprecated = Optional.of(deprecatedBy);
        } else if (!deprecatedBy.isEmpty()) {
            this.log.warn(warning);
            deprecated = Optional.of(deprecatedBy);
        }
        return deprecated;
    }

    private Mode mode(org.neo4j.procedure.Mode incoming) {
        switch (incoming) {
            case DBMS: {
                return Mode.DBMS;
            }
            case SCHEMA: {
                return Mode.SCHEMA_WRITE;
            }
            case WRITE: {
                return Mode.READ_WRITE;
            }
        }
        return Mode.READ_ONLY;
    }

    private Optional<String> description(Method method) {
        if (method.isAnnotationPresent(Description.class)) {
            return Optional.of(method.getAnnotation(Description.class).value());
        }
        return Optional.empty();
    }

    private MethodHandle constructor(Class<?> procDefinition) throws ProcedureException {
        try {
            return this.lookup.unreflectConstructor(procDefinition.getConstructor(new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Unable to find a usable public no-argument constructor in the class `%s`. Please add a valid, public constructor, recompile the class and try again.", procDefinition.getSimpleName());
        }
    }

    private QualifiedName extractName(Class<?> procDefinition, Method m, String valueName, String definedName) {
        String procName;
        String string = procName = definedName.trim().isEmpty() ? valueName : definedName;
        if (procName.trim().length() > 0) {
            String[] split = procName.split("\\.");
            if (split.length == 1) {
                return new QualifiedName(new String[0], split[0]);
            }
            int lastElement = split.length - 1;
            return new QualifiedName(Arrays.copyOf(split, lastElement), split[lastElement]);
        }
        Package pkg = procDefinition.getPackage();
        String[] namespace = pkg == null ? new String[]{} : pkg.getName().split("\\.");
        String name = m.getName();
        return new QualifiedName(namespace, name);
    }

    private static class ReflectiveUserFunction
    extends ReflectiveBase
    implements CallableUserFunction {
        private final TypeMappers.NeoValueConverter valueConverter;
        private final UserFunctionSignature signature;

        public ReflectiveUserFunction(UserFunctionSignature signature, MethodHandle constructor, MethodHandle procedureMethod, TypeMappers.NeoValueConverter outputMapper, List<FieldInjections.FieldSetter> fieldSetters) {
            super(constructor, procedureMethod, fieldSetters);
            this.signature = signature;
            this.valueConverter = outputMapper;
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public Object apply(Context ctx, Object[] input) throws ProcedureException {
            try {
                int numberOfDeclaredArguments = this.signature.inputSignature().size();
                if (numberOfDeclaredArguments != input.length) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Function `%s` takes %d arguments but %d was provided.", this.signature.name(), numberOfDeclaredArguments, input.length);
                }
                Object cls = this.constructor.invoke();
                this.inject(ctx, cls);
                Object[] args = this.args(numberOfDeclaredArguments, cls, input);
                Object rs = this.procedureMethod.invokeWithArguments(args);
                return this.valueConverter.toNeoValue(rs);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Status.HasStatus) {
                    throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                }
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke function `%s`: %s", this.signature.name(), "Caused by: " + throwable);
            }
        }
    }

    private static class ReflectiveProcedure
    extends ReflectiveBase
    implements CallableProcedure {
        protected final ProcedureSignature signature;
        private final OutputMappers.OutputMapper outputMapper;

        public ReflectiveProcedure(ProcedureSignature signature, MethodHandle constructor, MethodHandle procedureMethod, OutputMappers.OutputMapper outputMapper, List<FieldInjections.FieldSetter> fieldSetters) {
            super(constructor, procedureMethod, fieldSetters);
            this.signature = signature;
            this.outputMapper = outputMapper;
        }

        @Override
        public ProcedureSignature signature() {
            return this.signature;
        }

        @Override
        public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input) throws ProcedureException {
            try {
                int numberOfDeclaredArguments = this.signature.inputSignature().size();
                if (numberOfDeclaredArguments != input.length) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Procedure `%s` takes %d arguments but %d was provided.", this.signature.name(), numberOfDeclaredArguments, input.length);
                }
                Object cls = this.constructor.invoke();
                this.inject(ctx, cls);
                Object[] args = this.args(numberOfDeclaredArguments, cls, input);
                Object rs = this.procedureMethod.invokeWithArguments(args);
                if (rs == null) {
                    return Iterators.asRawIterator(Collections.emptyIterator());
                }
                return new MappingIterator(((Stream)rs).iterator());
            }
            catch (Throwable throwable) {
                if (throwable instanceof Status.HasStatus) {
                    throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                }
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke procedure `%s`: %s", this.signature.name(), "Caused by: " + throwable);
            }
        }

        private class MappingIterator
        implements RawIterator<Object[], ProcedureException> {
            private final Iterator<?> out;

            public MappingIterator(Iterator<?> out) {
                this.out = out;
            }

            public boolean hasNext() throws ProcedureException {
                try {
                    return this.out.hasNext();
                }
                catch (RuntimeException e) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, "Failed to call procedure `%s`: %s", ReflectiveProcedure.this.signature, e.getMessage());
                }
            }

            public Object[] next() throws ProcedureException {
                try {
                    Object record = this.out.next();
                    return ReflectiveProcedure.this.outputMapper.apply(record);
                }
                catch (RuntimeException e) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, "Failed to call procedure `%s`: %s", ReflectiveProcedure.this.signature, e.getMessage());
                }
            }
        }
    }

    private static abstract class ReflectiveBase {
        protected final MethodHandle constructor;
        protected final MethodHandle procedureMethod;
        protected final List<FieldInjections.FieldSetter> fieldSetters;

        protected ReflectiveBase(MethodHandle constructor, MethodHandle procedureMethod, List<FieldInjections.FieldSetter> fieldSetters) {
            this.constructor = constructor;
            this.procedureMethod = procedureMethod;
            this.fieldSetters = fieldSetters;
        }

        protected void inject(Context ctx, Object object) throws ProcedureException {
            for (FieldInjections.FieldSetter setter : this.fieldSetters) {
                setter.apply(ctx, object);
            }
        }

        protected Object[] args(int numberOfDeclaredArguments, Object cls, Object[] input) {
            Object[] args = new Object[numberOfDeclaredArguments + 1];
            args[0] = cls;
            System.arraycopy(input, 0, args, 1, numberOfDeclaredArguments);
            return args;
        }
    }
}

