/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Iterator;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class RelationshipGroupCache
implements Iterable<RelationshipGroupRecord>,
AutoCloseable {
    public static final int GROUP_ENTRY_SIZE = 22;
    private final ByteArray groupCountCache;
    private final ByteArray cache;
    private final long highNodeId;
    private final LongArray offsets = NumberArrayFactory.AUTO.newDynamicLongArray(100000L, 0L);
    private final byte[] scratch = new byte[22];
    private long fromNodeId;
    private long toNodeId;
    private long highCacheId;

    public RelationshipGroupCache(NumberArrayFactory arrayFactory, long maxMemory, long highNodeId) {
        this.groupCountCache = arrayFactory.newByteArray(highNodeId, new byte[2]);
        this.highNodeId = highNodeId;
        long memoryDedicatedToCounting = 2L * highNodeId;
        long memoryLeftForGroupCache = maxMemory - memoryDedicatedToCounting;
        if (memoryLeftForGroupCache < 0L) {
            throw new IllegalArgumentException("Too little memory to cache any groups, provided " + Format.bytes(maxMemory) + " where " + Format.bytes(memoryDedicatedToCounting) + " was dedicated to group counting");
        }
        this.cache = arrayFactory.newByteArray(memoryLeftForGroupCache / 22L, new byte[22]);
    }

    public void incrementGroupCount(long nodeId) {
        int count = this.groupCountCache.getShort(nodeId, 0) & 0xFFFF;
        if ((++count & 0xFFFF0000) != 0) {
            throw new IllegalStateException("Invalid number of relationship groups for node " + nodeId + " " + count);
        }
        this.groupCountCache.setShort(nodeId, 0, (short)count);
    }

    ByteArray getGroupCountCache() {
        return this.groupCountCache;
    }

    public long prepare(long fromNodeId) {
        this.cache.clear();
        this.fromNodeId = fromNodeId;
        this.highCacheId = 0L;
        for (long nodeId = fromNodeId; nodeId < this.highNodeId; ++nodeId) {
            short count = this.groupCountCache.getShort(nodeId, 0);
            if (this.highCacheId + (long)count > this.cache.length()) {
                this.toNodeId = nodeId;
                return this.toNodeId;
            }
            this.offsets.set(this.rebase(nodeId), this.highCacheId);
            this.highCacheId += (long)count;
        }
        this.toNodeId = this.highNodeId;
        return this.toNodeId;
    }

    private long rebase(long toNodeId) {
        return toNodeId - this.fromNodeId;
    }

    public boolean put(RelationshipGroupRecord groupRecord) {
        long nodeId = groupRecord.getOwningNode();
        assert (nodeId < this.highNodeId);
        if (nodeId < this.fromNodeId || nodeId >= this.toNodeId) {
            return false;
        }
        long baseIndex = this.offsets.get(this.rebase(nodeId));
        short groupCount = this.groupCountCache.getShort(nodeId, 0);
        long index = this.scanForFreeFrom(baseIndex, groupCount, groupRecord.getType());
        this.cache.setByte(index, 0, (byte)1);
        this.cache.set3ByteInt(index, 1, groupRecord.getType());
        this.cache.set6ByteLong(index, 4, groupRecord.getFirstOut());
        this.cache.set6ByteLong(index, 10, groupRecord.getFirstIn());
        this.cache.set6ByteLong(index, 16, groupRecord.getFirstLoop());
        return true;
    }

    private long scanForFreeFrom(long startIndex, int groupCount, int type) {
        long desiredIndex = -1L;
        long freeIndex = -1L;
        for (int i = 0; i < groupCount; ++i) {
            boolean free;
            long candidateIndex = startIndex + (long)i;
            boolean bl = free = this.cache.getByte(candidateIndex, 0) == 0;
            if (free) {
                freeIndex = candidateIndex;
                break;
            }
            if (desiredIndex != -1L) continue;
            int existingType = this.cache.get3ByteInt(candidateIndex, 1);
            if (existingType == type) {
                throw new IllegalStateException("Tried to put multiple groups with same type " + type);
            }
            if (type >= existingType) continue;
            desiredIndex = candidateIndex;
        }
        if (freeIndex == -1L) {
            throw new IllegalStateException("There's no room for me for startIndex:" + startIndex + " with a group count of " + groupCount + ". This means that there's an asymmetry between calls to incrementGroupCount and actual contents sent into put");
        }
        if (desiredIndex != -1L) {
            this.moveRight(desiredIndex, freeIndex);
            return desiredIndex;
        }
        return freeIndex;
    }

    private void moveRight(long fromIndex, long toIndex) {
        for (long index = toIndex; index > fromIndex; --index) {
            this.cache.get(index - 1L, this.scratch);
            this.cache.set(index, this.scratch);
        }
    }

    @Override
    public Iterator<RelationshipGroupRecord> iterator() {
        return new PrefetchingIterator<RelationshipGroupRecord>(){
            private long cursor;
            private long nodeId;
            private int countLeftForThisNode;
            {
                this.nodeId = RelationshipGroupCache.this.fromNodeId;
                this.countLeftForThisNode = RelationshipGroupCache.this.groupCountCache.getShort(this.nodeId, 0);
                this.findNextNodeWithGroupsIfNeeded();
            }

            protected RelationshipGroupRecord fetchNextOrNull() {
                while (this.cursor < RelationshipGroupCache.this.highCacheId) {
                    RelationshipGroupRecord group = null;
                    if (RelationshipGroupCache.this.cache.getByte(this.cursor, 0) == 1) {
                        group = new RelationshipGroupRecord(-1L).initialize(true, RelationshipGroupCache.this.cache.get3ByteInt(this.cursor, 1), RelationshipGroupCache.this.cache.get6ByteLong(this.cursor, 4), RelationshipGroupCache.this.cache.get6ByteLong(this.cursor, 10), RelationshipGroupCache.this.cache.get6ByteLong(this.cursor, 16), this.nodeId, this.countLeftForThisNode - 1);
                    }
                    ++this.cursor;
                    --this.countLeftForThisNode;
                    this.findNextNodeWithGroupsIfNeeded();
                    if (group == null) continue;
                    return group;
                }
                return null;
            }

            private void findNextNodeWithGroupsIfNeeded() {
                if (this.countLeftForThisNode == 0) {
                    do {
                        ++this.nodeId;
                        int n = this.countLeftForThisNode = this.nodeId >= RelationshipGroupCache.this.groupCountCache.length() ? 0 : (int)RelationshipGroupCache.this.groupCountCache.getShort(this.nodeId, 0);
                    } while (this.countLeftForThisNode == 0 && this.nodeId < RelationshipGroupCache.this.groupCountCache.length());
                }
            }
        };
    }

    @Override
    public void close() {
        this.cache.close();
        this.offsets.close();
    }
}

