/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;

public class LuceneIndexWriter
implements Closeable {
    private static final long MAX_DOC_LIMIT = 0x7FFFFF7FL;
    protected final IndexWriter writer;

    LuceneIndexWriter(Directory dir, IndexWriterConfig conf) throws IOException {
        this.writer = new IndexWriter(dir, conf);
    }

    public void addDocument(Document document) throws IOException, IndexCapacityExceededException {
        this.writer.addDocument(document);
    }

    public void updateDocument(Term term, Document document) throws IOException, IndexCapacityExceededException {
        this.writer.updateDocument(term, document);
    }

    public void deleteDocuments(Term term) throws IOException {
        this.writer.deleteDocuments(term);
    }

    public void deleteDocuments(Query query) throws IOException {
        this.writer.deleteDocuments(query);
    }

    public void optimize() throws IOException {
        this.writer.optimize(true);
    }

    public SearcherManager createSearcherManager() throws IOException {
        return new SearcherManager(this.writer, true, new SearcherFactory());
    }

    public void commit() throws IOException {
        this.writer.commit();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.writer.getConfig().getIndexDeletionPolicy();
    }

    void commit(Map<String, String> commitUserData) throws IOException {
        this.writer.commit(commitUserData);
    }

    void close(boolean waitForMerges) throws IOException {
        this.writer.close(waitForMerges);
    }

    long maxDocLimit() {
        return 0x7FFFFF7FL;
    }
}

