/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.ReadOnlyIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.ReadOnlyDatabaseSchemaIndex;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.WritableDatabaseSchemaIndex;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;

public class LuceneSchemaIndexBuilder
extends AbstractLuceneIndexBuilder<LuceneSchemaIndexBuilder> {
    private IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.empty());
    private IndexConfiguration indexConfig = IndexConfiguration.NON_UNIQUE;
    private Factory<IndexWriterConfig> writerConfigFactory = IndexWriterConfigs::standard;

    private LuceneSchemaIndexBuilder() {
    }

    public static LuceneSchemaIndexBuilder create() {
        return new LuceneSchemaIndexBuilder();
    }

    public LuceneSchemaIndexBuilder withSamplingConfig(IndexSamplingConfig samplingConfig) {
        this.samplingConfig = samplingConfig;
        return this;
    }

    public LuceneSchemaIndexBuilder withIndexConfig(IndexConfiguration indexConfig) {
        this.indexConfig = indexConfig;
        return this;
    }

    public LuceneSchemaIndexBuilder withWriterConfig(Factory<IndexWriterConfig> writerConfigFactory) {
        this.writerConfigFactory = writerConfigFactory;
        return this;
    }

    public LuceneSchemaIndexBuilder uniqueIndex() {
        this.indexConfig = IndexConfiguration.UNIQUE;
        return this;
    }

    public SchemaIndex build() {
        if (this.isReadOnly()) {
            return new ReadOnlyDatabaseSchemaIndex(this.storageBuilder.build(), this.indexConfig, this.samplingConfig, new ReadOnlyIndexPartitionFactory());
        }
        Boolean archiveFailed = (Boolean)this.getConfig(GraphDatabaseSettings.archive_failed_index);
        PartitionedIndexStorage storage = this.storageBuilder.archivingFailed(archiveFailed).build();
        return new WritableDatabaseSchemaIndex(storage, this.indexConfig, this.samplingConfig, new WritableIndexPartitionFactory(this.writerConfigFactory));
    }
}

