/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.support;

public final class ClassUtils {
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static boolean isEnum(Class<?> clazz) {
        return clazz.isEnum() || Enum.class.isAssignableFrom(clazz);
    }

    public static boolean isEnum(Object object) {
        if (object == null) {
            return false;
        }
        return ClassUtils.isEnum(object.getClass());
    }

    private ClassUtils() {
    }
}

