/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.compiler.builders.node;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.compiler.NodeBuilder;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.PropertyModel;

public class DefaultNodeBuilder
implements NodeBuilder {
    NodeModel node = new NodeModel();

    public DefaultNodeBuilder(Long reference) {
        this.node.setId(reference);
    }

    public NodeBuilder addProperty(String key, Object value) {
        List propertyList = this.node.getPropertyList();
        for (Property property : propertyList) {
            if (!((String)property.getKey()).equals(key)) continue;
            throw new MappingException("Node model already contains property: " + key);
        }
        propertyList.add(new PropertyModel((Object)key, value));
        return this;
    }

    public NodeBuilder addProperties(Map<String, ?> properties) {
        for (String key : properties.keySet()) {
            this.addProperty(key, properties.get(key));
        }
        return this;
    }

    public NodeBuilder addLabels(Collection<String> newLabels) {
        String[] labels = newLabels.toArray(new String[newLabels.size()]);
        this.node.setLabels(labels);
        return this;
    }

    public Long reference() {
        return this.node.getId();
    }

    public String[] addedLabels() {
        return this.node.getLabels();
    }

    public NodeBuilder removeLabels(Collection<String> removedLabels) {
        String[] labels = removedLabels.toArray(new String[removedLabels.size()]);
        this.node.removeLabels(labels);
        return this;
    }

    public Node node() {
        return this.node;
    }

    public NodeBuilder setPrimaryIndex(String primaryIndexField) {
        this.node.setPrimaryIndex(primaryIndexField);
        return this;
    }
}

