/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.CollectionUtils;
import org.neo4j.ogm.annotation.Index;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.classloader.MetaDataClassLoader;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.AnnotationsInfo;
import org.neo4j.ogm.metadata.ClassValidator;
import org.neo4j.ogm.metadata.ConstantPool;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.FieldsInfo;
import org.neo4j.ogm.metadata.InterfacesInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.metadata.MethodsInfo;
import org.neo4j.ogm.session.Neo4jException;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInfo.class);
    private final List<ClassInfo> directSubclasses = new ArrayList<ClassInfo>();
    private final List<ClassInfo> directInterfaces = new ArrayList<ClassInfo>();
    private final List<ClassInfo> directImplementingClasses = new ArrayList<ClassInfo>();
    private final Lock lock = new ReentrantLock();
    private String className;
    private String directSuperclassName;
    private String neo4jName;
    private boolean isInterface;
    private boolean isAbstract;
    private boolean isEnum;
    private boolean hydrated;
    private FieldsInfo fieldsInfo = new FieldsInfo();
    private MethodsInfo methodsInfo = new MethodsInfo();
    private AnnotationsInfo annotationsInfo = new AnnotationsInfo();
    private InterfacesInfo interfacesInfo = new InterfacesInfo();
    private ClassInfo directSuperclass;
    private Map<Class, List<MethodInfo>> iterableGettersForType = new HashMap<Class, List<MethodInfo>>();
    private Map<Class, List<MethodInfo>> iterableSettersForType = new HashMap<Class, List<MethodInfo>>();
    private Map<Class, List<FieldInfo>> iterableFieldsForType = new HashMap<Class, List<FieldInfo>>();
    private Map<FieldInfo, Field> fieldInfoFields = new ConcurrentHashMap<FieldInfo, Field>();
    private volatile Set<FieldInfo> fieldInfos;
    private volatile Map<String, FieldInfo> propertyFields;
    private volatile Map<String, FieldInfo> indexFields;
    private volatile FieldInfo identityField = null;
    private volatile FieldInfo primaryIndexField = null;
    private volatile FieldInfo labelField = null;
    private volatile boolean labelFieldMapped = false;
    private boolean primaryIndexFieldChecked = false;

    public ClassInfo(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream, 1024));
        if (dataInputStream.readInt() != -889275714) {
            return;
        }
        dataInputStream.readUnsignedShort();
        dataInputStream.readUnsignedShort();
        ConstantPool constantPool = new ConstantPool(dataInputStream);
        int flags = dataInputStream.readUnsignedShort();
        this.isInterface = (flags & 0x200) != 0;
        this.isAbstract = (flags & 0x400) != 0;
        this.isEnum = (flags & 0x4000) != 0;
        this.className = constantPool.lookup(dataInputStream.readUnsignedShort()).replace('/', '.');
        String sce = constantPool.lookup(dataInputStream.readUnsignedShort());
        if (sce != null) {
            this.directSuperclassName = sce.replace('/', '.');
        }
        this.interfacesInfo = new InterfacesInfo(dataInputStream, constantPool);
        this.fieldsInfo = new FieldsInfo(dataInputStream, constantPool);
        this.methodsInfo = new MethodsInfo(dataInputStream, constantPool);
        this.annotationsInfo = new AnnotationsInfo(dataInputStream, constantPool);
        new ClassValidator(this).validate();
        this.primaryIndexField = this.primaryIndexField();
    }

    public ClassInfo(String name, ClassInfo subclass) {
        this.className = name;
        this.hydrated = false;
        this.addSubclass(subclass);
    }

    public void hydrate(ClassInfo classInfoDetails) {
        if (!this.hydrated) {
            this.hydrated = true;
            this.isAbstract = classInfoDetails.isAbstract;
            this.isInterface = classInfoDetails.isInterface;
            this.isEnum = classInfoDetails.isEnum;
            this.directSuperclassName = classInfoDetails.directSuperclassName;
            this.interfacesInfo.append(classInfoDetails.interfacesInfo());
            this.annotationsInfo.append(classInfoDetails.annotationsInfo());
            this.fieldsInfo.append(classInfoDetails.fieldsInfo());
            this.methodsInfo.append(classInfoDetails.methodsInfo());
        }
    }

    void extend(ClassInfo classInfo) {
        this.interfacesInfo.append(classInfo.interfacesInfo());
        this.fieldsInfo.append(classInfo.fieldsInfo());
        this.methodsInfo.append(classInfo.methodsInfo());
    }

    public void addSubclass(ClassInfo subclass) {
        if (subclass.directSuperclass != null && subclass.directSuperclass != this) {
            throw new RuntimeException(subclass.className + " has two superclasses: " + subclass.directSuperclass.className + ", " + this.className);
        }
        subclass.directSuperclass = this;
        this.directSubclasses.add(subclass);
    }

    public boolean hydrated() {
        return this.hydrated;
    }

    public String name() {
        return this.className;
    }

    String simpleName() {
        return this.className.substring(this.className.lastIndexOf(46) + 1);
    }

    ClassInfo directSuperclass() {
        return this.directSuperclass;
    }

    public Collection<String> staticLabels() {
        return this.collectLabels(new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String neo4jName() {
        if (this.neo4jName == null) {
            try {
                this.lock.lock();
                if (this.neo4jName == null) {
                    AnnotationInfo annotationInfo = this.annotationsInfo.get("org.neo4j.ogm.annotation.NodeEntity");
                    if (annotationInfo != null) {
                        String string = this.neo4jName = annotationInfo.get("label", this.simpleName());
                        return string;
                    }
                    annotationInfo = this.annotationsInfo.get("org.neo4j.ogm.annotation.RelationshipEntity");
                    if (annotationInfo != null) {
                        String string = this.neo4jName = annotationInfo.get("type", this.simpleName().toUpperCase());
                        return string;
                    }
                    this.neo4jName = this.simpleName();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.neo4jName;
    }

    private Collection<String> collectLabels(Collection<String> labelNames) {
        if (!this.isAbstract || this.annotationsInfo.get("org.neo4j.ogm.annotation.NodeEntity") != null) {
            labelNames.add(this.neo4jName());
        }
        if (this.directSuperclass != null && !"java.lang.Object".equals(this.directSuperclass.className)) {
            this.directSuperclass.collectLabels(labelNames);
        }
        for (ClassInfo interfaceInfo : this.directInterfaces()) {
            interfaceInfo.collectLabels(labelNames);
        }
        return labelNames;
    }

    public List<ClassInfo> directSubclasses() {
        return this.directSubclasses;
    }

    public List<ClassInfo> directImplementingClasses() {
        return this.directImplementingClasses;
    }

    public List<ClassInfo> directInterfaces() {
        return this.directInterfaces;
    }

    public InterfacesInfo interfacesInfo() {
        return this.interfacesInfo;
    }

    public Collection<AnnotationInfo> annotations() {
        return this.annotationsInfo.list();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public AnnotationsInfo annotationsInfo() {
        return this.annotationsInfo;
    }

    public String superclassName() {
        return this.directSuperclassName;
    }

    public FieldsInfo fieldsInfo() {
        return this.fieldsInfo;
    }

    public MethodsInfo methodsInfo() {
        return this.methodsInfo;
    }

    public String toString() {
        return this.name();
    }

    private FieldInfo identityFieldOrNull() {
        try {
            return this.identityField();
        }
        catch (MappingException me) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo identityField() {
        if (this.identityField != null) {
            return this.identityField;
        }
        try {
            this.lock.lock();
            if (this.identityField == null) {
                for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                    AnnotationInfo annotationInfo = fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.GraphId");
                    if (annotationInfo == null || !fieldInfo.getTypeDescriptor().equals("Ljava/lang/Long;")) continue;
                    this.identityField = fieldInfo;
                    FieldInfo fieldInfo2 = fieldInfo;
                    return fieldInfo2;
                }
                FieldInfo fieldInfo = this.fieldsInfo().get("id");
                if (fieldInfo != null && fieldInfo.getTypeDescriptor().equals("Ljava/lang/Long;")) {
                    this.identityField = fieldInfo;
                    FieldInfo fieldInfo3 = fieldInfo;
                    return fieldInfo3;
                }
                throw new MappingException("No identity field found for class: " + this.className);
            }
            FieldInfo fieldInfo = this.identityField;
            return fieldInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo labelFieldOrNull() {
        block8: {
            if (this.labelFieldMapped) {
                return this.labelField;
            }
            try {
                this.lock.lock();
                if (!this.labelFieldMapped) {
                    for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                        if (!fieldInfo.isLabelField()) continue;
                        if (!fieldInfo.isIterable()) {
                            throw new MappingException(String.format("Field '%s' in class '%s' includes the @Labels annotation, however this field is not a type of collection.", fieldInfo.getName(), this.name()));
                        }
                        this.labelFieldMapped = true;
                        FieldInfo fieldInfo2 = this.labelField = fieldInfo;
                        return fieldInfo2;
                    }
                    break block8;
                }
                FieldInfo fieldInfo = this.labelField;
                return fieldInfo;
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    public boolean isRelationshipEntity() {
        for (AnnotationInfo info : this.annotations()) {
            if (!info.getName().equals("org.neo4j.ogm.annotation.RelationshipEntity")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FieldInfo> propertyFields() {
        if (this.fieldInfos == null) {
            try {
                this.lock.lock();
                if (this.fieldInfos == null) {
                    FieldInfo identityField = this.identityFieldOrNull();
                    this.fieldInfos = new HashSet<FieldInfo>();
                    for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                        if (fieldInfo == identityField || fieldInfo.isLabelField()) continue;
                        AnnotationInfo annotationInfo = fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.Property");
                        if (annotationInfo == null) {
                            if (!fieldInfo.persistableAsProperty()) continue;
                            this.fieldInfos.add(fieldInfo);
                            continue;
                        }
                        this.fieldInfos.add(fieldInfo);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.fieldInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo propertyField(String propertyName) {
        if (this.propertyFields == null) {
            try {
                this.lock.lock();
                if (this.propertyFields == null) {
                    Collection<FieldInfo> fieldInfos = this.propertyFields();
                    this.propertyFields = new HashMap<String, FieldInfo>(fieldInfos.size());
                    for (FieldInfo fieldInfo : fieldInfos) {
                        this.propertyFields.put(fieldInfo.property().toLowerCase(), fieldInfo);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.propertyFields.get(propertyName.toLowerCase());
    }

    public FieldInfo propertyFieldByName(String propertyName) {
        for (FieldInfo fieldInfo : this.propertyFields()) {
            if (!fieldInfo.getName().equalsIgnoreCase(propertyName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public Collection<FieldInfo> relationshipFields() {
        FieldInfo identityField = this.identityFieldOrNull();
        HashSet<FieldInfo> fieldInfos = new HashSet<FieldInfo>();
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (fieldInfo == identityField) continue;
            AnnotationInfo annotationInfo = fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.Relationship");
            if (annotationInfo == null) {
                if (fieldInfo.persistableAsProperty()) continue;
                fieldInfos.add(fieldInfo);
                continue;
            }
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    public FieldInfo relationshipField(String relationshipName) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            if (!fieldInfo.relationship().equalsIgnoreCase(relationshipName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public FieldInfo relationshipField(String relationshipName, String relationshipDirection, boolean strict) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            return fieldInfo;
        }
        return null;
    }

    public Set<FieldInfo> candidateRelationshipFields(String relationshipName, String relationshipDirection, boolean strict) {
        HashSet<FieldInfo> candidateFields = new HashSet<FieldInfo>();
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            candidateFields.add(fieldInfo);
        }
        return candidateFields;
    }

    public FieldInfo relationshipFieldByName(String fieldName) {
        for (FieldInfo fieldInfo : this.relationshipFields()) {
            if (!fieldInfo.getName().equalsIgnoreCase(fieldName)) continue;
            return fieldInfo;
        }
        return null;
    }

    public MethodInfo identityGetter() {
        for (MethodInfo methodInfo : this.methodsInfo().getters()) {
            AnnotationInfo annotationInfo = methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.GraphId");
            if (annotationInfo == null || !methodInfo.getTypeDescriptor().equals("()Ljava/lang/Long;")) continue;
            return methodInfo;
        }
        MethodInfo methodInfo = this.methodsInfo().get("getId");
        if (methodInfo != null && methodInfo.getTypeDescriptor().equals("()Ljava/lang/Long;")) {
            return methodInfo;
        }
        return null;
    }

    public MethodInfo identitySetter() {
        for (MethodInfo methodInfo : this.methodsInfo().setters()) {
            AnnotationInfo annotationInfo = methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.GraphId");
            if (annotationInfo == null || !methodInfo.getTypeDescriptor().equals("(Ljava/lang/Long;)V")) continue;
            return methodInfo;
        }
        MethodInfo methodInfo = this.methodsInfo().get("setId");
        if (methodInfo != null && methodInfo.getTypeDescriptor().equals("(Ljava/lang/Long;)V")) {
            return methodInfo;
        }
        return null;
    }

    public Collection<MethodInfo> propertyGetters() {
        MethodInfo identityGetter = this.identityGetter();
        HashSet<MethodInfo> propertyGetters = new HashSet<MethodInfo>();
        for (MethodInfo methodInfo : this.methodsInfo().getters()) {
            if (methodInfo.isEquallyNamed(identityGetter)) continue;
            AnnotationInfo annotationInfo = methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.Property");
            if (annotationInfo == null) {
                if (!methodInfo.isSimpleGetter()) continue;
                propertyGetters.add(methodInfo);
                continue;
            }
            propertyGetters.add(methodInfo);
        }
        return propertyGetters;
    }

    public Collection<MethodInfo> propertySetters() {
        MethodInfo identitySetter = this.identitySetter();
        HashSet<MethodInfo> propertySetters = new HashSet<MethodInfo>();
        for (MethodInfo methodInfo : this.methodsInfo().setters()) {
            if (methodInfo.isEquallyNamed(identitySetter)) continue;
            AnnotationInfo annotationInfo = methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.Property");
            if (annotationInfo == null) {
                if (!methodInfo.isSimpleSetter()) continue;
                propertySetters.add(methodInfo);
                continue;
            }
            propertySetters.add(methodInfo);
        }
        return propertySetters;
    }

    public Collection<MethodInfo> propertyGettersAndSetters() {
        return CollectionUtils.union(this.propertyGetters(), this.propertySetters());
    }

    public Collection<MethodInfo> relationshipGetters() {
        MethodInfo identityGetter = this.identityGetter();
        HashSet<MethodInfo> relationshipGetters = new HashSet<MethodInfo>();
        for (MethodInfo methodInfo : this.methodsInfo().getters()) {
            if (identityGetter != null && methodInfo.getName().equals(identityGetter.getName())) continue;
            AnnotationInfo annotationInfo = methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.Relationship");
            if (annotationInfo == null) {
                if (methodInfo.isSimpleGetter()) continue;
                relationshipGetters.add(methodInfo);
                continue;
            }
            relationshipGetters.add(methodInfo);
        }
        return relationshipGetters;
    }

    public Collection<MethodInfo> relationshipSetters() {
        MethodInfo identitySetter = this.identitySetter();
        HashSet<MethodInfo> relationshipSetters = new HashSet<MethodInfo>();
        for (MethodInfo methodInfo : this.methodsInfo().setters()) {
            if (identitySetter != null && methodInfo.getName().equals(identitySetter.getName())) continue;
            AnnotationInfo annotationInfo = methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.Relationship");
            if (annotationInfo == null) {
                if (methodInfo.isSimpleSetter()) continue;
                relationshipSetters.add(methodInfo);
                continue;
            }
            relationshipSetters.add(methodInfo);
        }
        return relationshipSetters;
    }

    public MethodInfo relationshipGetter(String relationshipName) {
        for (MethodInfo methodInfo : this.relationshipGetters()) {
            if (!methodInfo.relationship().equalsIgnoreCase(relationshipName)) continue;
            return methodInfo;
        }
        return null;
    }

    public MethodInfo relationshipGetter(String relationshipName, String relationshipDirection, boolean strict) {
        for (MethodInfo methodInfo : this.relationshipGetters()) {
            String relationship = strict ? methodInfo.relationshipTypeAnnotation() : methodInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!methodInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !methodInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || methodInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            return methodInfo;
        }
        return null;
    }

    public MethodInfo relationshipSetter(String relationshipName) {
        for (MethodInfo methodInfo : this.relationshipSetters()) {
            if (!methodInfo.relationship().equalsIgnoreCase(relationshipName)) continue;
            return methodInfo;
        }
        return null;
    }

    public MethodInfo relationshipSetter(String relationshipName, String relationshipDirection, boolean strict) {
        for (MethodInfo methodInfo : this.relationshipSetters()) {
            String relationship = strict ? methodInfo.relationshipTypeAnnotation() : methodInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!methodInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !methodInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || methodInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            return methodInfo;
        }
        return null;
    }

    public Set<MethodInfo> candidateRelationshipSetters(String relationshipName, String relationshipDirection, boolean strict) {
        HashSet<MethodInfo> candidateSetters = new HashSet<MethodInfo>();
        for (MethodInfo methodInfo : this.relationshipSetters()) {
            String relationship = strict ? methodInfo.relationshipTypeAnnotation() : methodInfo.relationship();
            if (!relationshipName.equalsIgnoreCase(relationship) || (!methodInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !methodInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || methodInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            candidateSetters.add(methodInfo);
        }
        return candidateSetters;
    }

    public MethodInfo propertySetter(String propertyName) {
        for (MethodInfo methodInfo : this.propertySetters()) {
            String match = methodInfo.property();
            if (!match.equalsIgnoreCase(propertyName) && !match.equalsIgnoreCase("set" + propertyName)) continue;
            return methodInfo;
        }
        return null;
    }

    public MethodInfo propertyGetter(String propertyName) {
        for (MethodInfo methodInfo : this.propertyGetters()) {
            String match = methodInfo.property();
            if (!match.equalsIgnoreCase(propertyName) && !match.equalsIgnoreCase("get" + propertyName)) continue;
            return methodInfo;
        }
        return null;
    }

    public Field getField(FieldInfo fieldInfo) {
        Field field = this.fieldInfoFields.get(fieldInfo);
        if (field != null) {
            return field;
        }
        try {
            field = MetaDataClassLoader.loadClass((String)this.name()).getDeclaredField(fieldInfo.getName());
            this.fieldInfoFields.put(fieldInfo, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (this.directSuperclass() != null) {
                field = this.directSuperclass().getField(fieldInfo);
                this.fieldInfoFields.put(fieldInfo, field);
                return field;
            }
            throw new RuntimeException("Field " + fieldInfo.getName() + " not found in class " + this.name() + " or any of its superclasses");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Method getMethod(MethodInfo methodInfo) {
        return methodInfo.getMethod(this.name());
    }

    public List<MethodInfo> findSetters(Class<?> parameterType) {
        String setterSignature = "(L" + parameterType.getName().replace(".", "/") + ";)V";
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (MethodInfo methodInfo : this.methodsInfo().methods()) {
            if (!methodInfo.isSetter() || !methodInfo.getTypeDescriptor().equals(setterSignature)) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    public List<MethodInfo> findGetters(Class<?> returnType) {
        String setterSignature = "()L" + returnType.getName().replace(".", "/") + ";";
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (MethodInfo methodInfo : this.methodsInfo().methods()) {
            if (!methodInfo.isGetter() || !methodInfo.getTypeDescriptor().equals(setterSignature)) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    public List<FieldInfo> findFields(Class<?> fieldType) {
        String fieldSignature = "L" + fieldType.getName().replace(".", "/") + ";";
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!fieldInfo.getTypeDescriptor().equals(fieldSignature)) continue;
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    public List<FieldInfo> findFields(String annotation) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!fieldInfo.hasAnnotation(annotation)) continue;
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    public List<FieldInfo> findIterableFields() {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        try {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                Class<?> type = this.getField(fieldInfo).getType();
                if (!type.isArray() && !Iterable.class.isAssignableFrom(type)) continue;
                fieldInfos.add(fieldInfo);
            }
            return fieldInfos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<FieldInfo> findIterableFields(Class iteratedType) {
        if (this.iterableFieldsForType.containsKey(iteratedType)) {
            return this.iterableFieldsForType.get(iteratedType);
        }
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        String typeSignature = "L" + iteratedType.getName().replace('.', '/') + ";";
        String arrayOfTypeSignature = "[" + typeSignature;
        try {
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                String fieldType = fieldInfo.getTypeDescriptor();
                if (fieldInfo.isArray() && (fieldType.equals(arrayOfTypeSignature) || fieldInfo.isParameterisedTypeOf(iteratedType))) {
                    fieldInfos.add(fieldInfo);
                    continue;
                }
                if (!fieldInfo.isIterable() || !fieldType.equals(typeSignature) && !fieldInfo.isParameterisedTypeOf(iteratedType)) continue;
                fieldInfos.add(fieldInfo);
            }
            this.iterableFieldsForType.put(iteratedType, fieldInfos);
            return fieldInfos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<FieldInfo> findIterableFields(Class iteratedType, String relationshipType, String relationshipDirection, boolean strict) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : this.findIterableFields(iteratedType)) {
            String relationship = strict ? fieldInfo.relationshipTypeAnnotation() : fieldInfo.relationship();
            if (!relationshipType.equals(relationship) || (!fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !fieldInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || fieldInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    public List<MethodInfo> findIterableSetters(Class iteratedType) {
        if (this.iterableSettersForType.containsKey(iteratedType)) {
            return this.iterableSettersForType.get(iteratedType);
        }
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        String typeSignature = "L" + iteratedType.getName().replace('.', '/') + ";";
        String arrayOfTypeSignature = "([" + typeSignature + ")V";
        try {
            String methodType;
            for (MethodInfo methodInfo : this.propertySetters()) {
                methodType = methodInfo.getTypeDescriptor();
                if (methodInfo.isArray() && (methodType.equals(arrayOfTypeSignature) || methodInfo.isParameterisedTypeOf(iteratedType))) {
                    methodInfos.add(methodInfo);
                    continue;
                }
                if (!methodInfo.isIterable() || !methodType.equals(typeSignature) && !methodInfo.isParameterisedTypeOf(iteratedType)) continue;
                methodInfos.add(methodInfo);
            }
            for (MethodInfo methodInfo : this.relationshipSetters()) {
                methodType = methodInfo.getTypeDescriptor();
                if (methodInfo.isArray() && (methodType.equals(arrayOfTypeSignature) || methodInfo.isParameterisedTypeOf(iteratedType))) {
                    methodInfos.add(methodInfo);
                    continue;
                }
                if (!methodInfo.isIterable() || !methodType.equals(typeSignature) && !methodInfo.isParameterisedTypeOf(iteratedType)) continue;
                methodInfos.add(methodInfo);
            }
            this.iterableSettersForType.put(iteratedType, methodInfos);
            return methodInfos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<MethodInfo> findIterableSetters(Class iteratedType, String relationshipType, String relationshipDirection, boolean strict) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (MethodInfo methodInfo : this.findIterableSetters(iteratedType)) {
            String relationship = strict ? methodInfo.relationshipTypeAnnotation() : methodInfo.relationship();
            if (!relationshipType.equals(relationship) || (!methodInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !methodInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || methodInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    public List<MethodInfo> findIterableGetters(Class iteratedType) {
        if (this.iterableGettersForType.containsKey(iteratedType)) {
            return this.iterableGettersForType.get(iteratedType);
        }
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        String typeSignature = "L" + iteratedType.getName().replace('.', '/') + ";";
        String arrayOfTypeSignature = "()[" + typeSignature;
        try {
            String methodType;
            for (MethodInfo methodInfo : this.propertyGetters()) {
                methodType = methodInfo.getTypeDescriptor();
                if (methodInfo.isArray() && methodType.equals(arrayOfTypeSignature)) {
                    methodInfos.add(methodInfo);
                    continue;
                }
                if (!methodInfo.isIterable() || !methodType.equals(typeSignature)) continue;
                methodInfos.add(methodInfo);
            }
            for (MethodInfo methodInfo : this.relationshipGetters()) {
                methodType = methodInfo.getTypeDescriptor();
                if (methodInfo.isArray() && methodType.equals(arrayOfTypeSignature)) {
                    methodInfos.add(methodInfo);
                    continue;
                }
                if (!methodInfo.isIterable() || !methodType.equals(typeSignature)) continue;
                methodInfos.add(methodInfo);
            }
            this.iterableGettersForType.put(iteratedType, methodInfos);
            return methodInfos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<MethodInfo> findIterableGetters(Class iteratedType, String relationshipType, String relationshipDirection, boolean strict) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (MethodInfo methodInfo : this.findIterableGetters(iteratedType)) {
            String relationship = strict ? methodInfo.relationshipTypeAnnotation() : methodInfo.relationship();
            if (!relationshipType.equals(relationship) || (!methodInfo.relationshipDirection("OUTGOING").equals("INCOMING") && !methodInfo.relationshipDirection("OUTGOING").equals("UNDIRECTED") || !relationshipDirection.equals("INCOMING")) && (!relationshipDirection.equals("OUTGOING") || methodInfo.relationshipDirection("OUTGOING").equals("INCOMING"))) continue;
            methodInfos.add(methodInfo);
        }
        return methodInfos;
    }

    public boolean isTransient() {
        return this.annotationsInfo.get("org.neo4j.ogm.annotation.Transient") != null;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isSubclassOf(ClassInfo classInfo) {
        ClassInfo subclass;
        if (this == classInfo) {
            return true;
        }
        boolean found = false;
        Iterator<ClassInfo> i$ = classInfo.directSubclasses().iterator();
        while (i$.hasNext() && !(found = this.isSubclassOf(subclass = i$.next()))) {
        }
        return found;
    }

    public Class<?> getType(String typeParameterDescriptor) {
        return ClassUtils.getType(typeParameterDescriptor);
    }

    public Class getUnderlyingClass() {
        try {
            return MetaDataClassLoader.loadClass((String)this.className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Could not get underlying class for {}", (Object)this.className);
            return null;
        }
    }

    public Class getTypeParameterDescriptorForRelationship(String relationshipType, String relationshipDirection) {
        boolean STRICT_MODE = true;
        boolean INFERRED_MODE = false;
        try {
            MethodInfo methodInfo = this.relationshipSetter(relationshipType, relationshipDirection, true);
            if (methodInfo != null && methodInfo.getTypeDescriptor() != null) {
                return ClassUtils.getType(methodInfo.getTypeDescriptor());
            }
            FieldInfo fieldInfo = this.relationshipField(relationshipType, relationshipDirection, true);
            if (fieldInfo != null && fieldInfo.getTypeDescriptor() != null) {
                return ClassUtils.getType(fieldInfo.getTypeDescriptor());
            }
            if (!relationshipDirection.equals("INCOMING")) {
                methodInfo = this.relationshipSetter(relationshipType, relationshipDirection, false);
                if (methodInfo != null && methodInfo.getTypeDescriptor() != null) {
                    return ClassUtils.getType(methodInfo.getTypeDescriptor());
                }
                fieldInfo = this.relationshipField(relationshipType, relationshipDirection, false);
                if (fieldInfo != null && fieldInfo.getTypeDescriptor() != null) {
                    return ClassUtils.getType(fieldInfo.getTypeDescriptor());
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.debug("Could not get {} class type for relationshipType {} and relationshipDirection {} ", new Object[]{this.className, relationshipType, relationshipDirection});
        }
        return null;
    }

    public boolean containsIndexes() {
        return !this.getIndexFields().isEmpty();
    }

    public Collection<FieldInfo> getIndexFields() {
        if (this.indexFields == null) {
            this.indexFields = this.addIndexes();
        }
        return this.indexFields.values();
    }

    private Map<String, FieldInfo> addIndexes() {
        Field[] declaredFields;
        HashMap<String, FieldInfo> indexes = new HashMap<String, FieldInfo>();
        try {
            declaredFields = MetaDataClassLoader.loadClass((String)this.className).getDeclaredFields();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not reflectively read declared fields", e);
        }
        String indexAnnotation = Index.class.getCanonicalName();
        for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
            if (!ClassInfo.isDeclaredField(declaredFields, fieldInfo.getName()) || !fieldInfo.hasAnnotation(indexAnnotation)) continue;
            String propertyValue = fieldInfo.property();
            if (fieldInfo.hasAnnotation(Property.class.getCanonicalName())) {
                propertyValue = fieldInfo.property();
            }
            indexes.put(propertyValue, fieldInfo);
        }
        return indexes;
    }

    private static boolean isDeclaredField(Field[] declaredFields, String name) {
        for (Field field : declaredFields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public FieldInfo primaryIndexField() {
        if (!this.primaryIndexFieldChecked && this.primaryIndexField == null) {
            String indexAnnotation = Index.class.getCanonicalName();
            for (FieldInfo fieldInfo : this.fieldsInfo().fields()) {
                AnnotationInfo annotationInfo = fieldInfo.getAnnotations().get(indexAnnotation);
                if (annotationInfo == null || annotationInfo.get("primary") == null || !annotationInfo.get("primary").equals("true")) continue;
                if (this.primaryIndexField == null) {
                    this.primaryIndexField = fieldInfo;
                    continue;
                }
                throw new Neo4jException("Each class may only define one primary index.");
            }
            this.primaryIndexFieldChecked = true;
        }
        return this.primaryIndexField;
    }
}

