/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.support.ClassUtils;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapCompositeConverter
implements CompositeAttributeConverter<Map<?, ?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapCompositeConverter.class);
    private static final Set<Class> cypherTypes;
    private static final Set<Class> castableTypes;
    private final String prefix;
    private final String delimiter;
    private final boolean allowCast;
    private final ParameterizedType mapFieldType;
    private final String firstPart;

    @Deprecated
    public MapCompositeConverter(String prefix, String delimiter, boolean allowCast, ParameterizedType mapFieldType) {
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.allowCast = allowCast;
        this.mapFieldType = mapFieldType;
        this.firstPart = prefix + delimiter;
    }

    @Override
    public Map<String, ?> toGraphProperties(Map<?, ?> fieldValue) {
        if (fieldValue == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> graphProperties = new HashMap<String, Object>(fieldValue.size());
        this.addMapToProperties(fieldValue, graphProperties, this.firstPart);
        return graphProperties;
    }

    private void addMapToProperties(Map<?, ?> fieldValue, Map<String, Object> graphProperties, String prefix) {
        for (Map.Entry<?, ?> entry : fieldValue.entrySet()) {
            Object entryValue = entry.getValue();
            String entryKey = prefix + this.keyInstanceToString(entry.getKey());
            if (entryValue instanceof Map) {
                this.addMapToProperties((Map)entryValue, graphProperties, entryKey + this.delimiter);
                continue;
            }
            if (this.isCypherType(entryValue) || this.allowCast && this.canCastType(entryValue)) {
                graphProperties.put(entryKey, entryValue);
                continue;
            }
            throw new MappingException("Could not map key=" + prefix + entry.getKey() + ", value=" + entryValue + " (type = " + entryValue.getClass() + ") because it is not a supported type.");
        }
    }

    private boolean canCastType(Object value) {
        return castableTypes.contains(value.getClass());
    }

    private boolean isCypherType(Object entryValue) {
        return cypherTypes.contains(entryValue.getClass()) || List.class.isAssignableFrom(entryValue.getClass());
    }

    @Override
    public Map<?, ?> toEntityAttribute(Map<String, ?> value) {
        Set prefixedProperties = value.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.firstPart)).collect(Collectors.toSet());
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Map.Entry entry2 : prefixedProperties) {
            String propertyKey = ((String)entry2.getKey()).substring(this.firstPart.length());
            this.putToMap(result, propertyKey, entry2.getValue(), this.mapFieldType);
        }
        return result;
    }

    private void putToMap(Map<Object, Object> result, String propertyKey, Object value, Type fieldType) {
        if (propertyKey.contains(this.delimiter)) {
            int delimiterIndex = propertyKey.indexOf(this.delimiter);
            String key = propertyKey.substring(0, delimiterIndex);
            Object keyInstance = this.keyInstanceFromString(key, this.getKeyType(fieldType));
            HashMap<Object, Object> o = (HashMap<Object, Object>)result.get(key);
            if (o == null) {
                o = new HashMap<Object, Object>();
                result.put(keyInstance, o);
            }
            this.putToMap(o, propertyKey.substring(delimiterIndex + this.delimiter.length()), value, this.nestedFieldType(fieldType));
        } else {
            Object keyInstance = this.keyInstanceFromString(propertyKey, this.getKeyType(fieldType));
            Type valueType = this.nestedFieldType(fieldType);
            if (valueType != null) {
                result.put(keyInstance, Utils.coerceTypes((Class)valueType, value));
            } else {
                result.put(keyInstance, value);
            }
        }
    }

    private Class<?> getKeyType(Type fieldType) {
        if (fieldType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)fieldType).getActualTypeArguments()[0];
        }
        return null;
    }

    private Type nestedFieldType(Type keyType) {
        if (keyType instanceof ParameterizedType) {
            return ((ParameterizedType)keyType).getActualTypeArguments()[1];
        }
        return null;
    }

    private String keyInstanceToString(Object propertyKey) {
        if (propertyKey == null) {
            throw new UnsupportedOperationException("Null is not a supported property key!");
        }
        if (propertyKey instanceof String) {
            return (String)propertyKey;
        }
        if (ClassUtils.isEnum((Object)propertyKey)) {
            return ((Enum)propertyKey).name();
        }
        throw new UnsupportedOperationException("Only String and Enum allowed to be keys, got " + propertyKey.getClass());
    }

    private Object keyInstanceFromString(String propertyKey, Class<?> keyType) {
        if (keyType == null) {
            return propertyKey;
        }
        if (keyType.equals(String.class)) {
            return propertyKey;
        }
        if (ClassUtils.isEnum(keyType)) {
            try {
                return keyType.getDeclaredMethod("valueOf", String.class).invoke(keyType, propertyKey);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Should not happen", e);
            }
        }
        throw new UnsupportedOperationException("Only String and Enum allowed to be keys, got " + keyType);
    }

    static {
        HashSet<Class<List>> types = new HashSet<Class<List>>();
        types.add(Boolean.class);
        types.add(Long.class);
        types.add(Double.class);
        types.add(String.class);
        types.add(List.class);
        cypherTypes = Collections.unmodifiableSet(types);
        HashSet<Class<Float>> castable = new HashSet<Class<Float>>();
        castable.add(Short.class);
        castable.add(Integer.class);
        castable.add(Float.class);
        castableTypes = Collections.unmodifiableSet(castable);
    }
}

