/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.junit;

import java.io.File;
import java.net.URI;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.harness.TestServerBuilders;

public class Neo4jRule
implements TestRule,
TestServerBuilder {
    private ServerControls controls;
    private TestServerBuilder builder;

    public Neo4jRule() {
        this.builder = TestServerBuilders.newInProcessBuilder();
    }

    public Neo4jRule(File workingDirectory) {
        this.builder = TestServerBuilders.newInProcessBuilder(workingDirectory);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try (ServerControls _ = Neo4jRule.this.controls = Neo4jRule.this.builder.newServer();){
                    base.evaluate();
                }
            }
        };
    }

    @Override
    public ServerControls newServer() {
        throw new UnsupportedOperationException("The server cannot be manually started via this class, it must be used as a JUnit rule.");
    }

    @Override
    public Neo4jRule withConfig(Setting<?> key, String value) {
        this.builder = this.builder.withConfig(key, value);
        return this;
    }

    @Override
    public Neo4jRule withConfig(String key, String value) {
        this.builder = this.builder.withConfig(key, value);
        return this;
    }

    @Override
    public Neo4jRule withExtension(String mountPath, Class<?> extension) {
        this.builder = this.builder.withExtension(mountPath, extension);
        return this;
    }

    @Override
    public Neo4jRule withExtension(String mountPath, String packageName) {
        this.builder = this.builder.withExtension(mountPath, packageName);
        return this;
    }

    @Override
    public Neo4jRule withFixture(File cypherFileOrDirectory) {
        this.builder = this.builder.withFixture(cypherFileOrDirectory);
        return this;
    }

    @Override
    public Neo4jRule withFixture(String fixtureStatement) {
        this.builder = this.builder.withFixture(fixtureStatement);
        return this;
    }

    public URI httpURI() {
        if (this.controls == null) {
            throw new IllegalStateException("Cannot access instance URI before or after the test runs.");
        }
        return this.controls.httpURI();
    }

    public URI httpsURI() {
        if (this.controls == null) {
            throw new IllegalStateException("Cannot access instance URI before or after the test runs.");
        }
        return this.controls.httpURI();
    }
}

