/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nlpcn.commons.lang.util.FileIterator;
import org.nlpcn.commons.lang.util.ObjConver;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class IOUtil {
    private static final Log LOG = LogFactory.getLog();
    public static final String UTF8 = "utf-8";
    public static final String GBK = "gbk";
    public static final String TABLE = "\t";
    public static final String LINE = "\n";
    public static final byte[] TABBYTE = "\t".getBytes();
    public static final byte[] LINEBYTE = "\n".getBytes();

    public static InputStream getInputStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedReader getReader(String path, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        return IOUtil.getReader(new File(path), charEncoding);
    }

    public static BufferedReader getReader(File file, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream is = new FileInputStream(file);
        return new BufferedReader(new InputStreamReader((InputStream)is, charEncoding));
    }

    public static RandomAccessFile getRandomAccessFile(String path, String charEncoding) throws FileNotFoundException {
        InputStream is = IOUtil.getInputStream(path);
        if (is != null) {
            return new RandomAccessFile(new File(path), "r");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void Writer(String path, String charEncoding, String content) {
        block7: {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(path));
                ((OutputStream)fos).write(content.getBytes(charEncoding));
                fos.flush();
                IOUtil.close(fos);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtil.close(fos);
            }
        }
    }

    public static BufferedReader getReader(InputStream inputStream, String charEncoding) throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(inputStream, charEncoding));
    }

    public static String getContent(String path, String charEncoding) {
        return IOUtil.getContent(new File(path), charEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(InputStream is, String charEncoding) {
        BufferedReader reader = null;
        try {
            reader = IOUtil.getReader(is, charEncoding);
            String string = IOUtil.getContent(reader);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getContent(File file, String charEncoding) {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            string = IOUtil.getContent(is, charEncoding);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close(is);
            return "";
        }
        IOUtil.close(is);
        return string;
    }

    public static String getContent(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                sb.append(temp);
                sb.append(LINE);
            }
        }
        finally {
            IOUtil.close(reader);
        }
        return sb.toString();
    }

    public static void WriterObj(String path, Serializable hm) throws FileNotFoundException, IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(path));
            objectOutputStream.writeObject(hm);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.flush();
                os.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static FileIterator instanceFileIterator(String path, String charEncoding) {
        try {
            return IOUtil.instanceFileIterator(IOUtil.getInputStream(path), charEncoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FileIterator instanceFileIterator(InputStream is, String charEncoding) {
        try {
            return new FileIterator(is, charEncoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> HashMap<K, V> loadMap(String path, String charEncoding, Class<K> key, Class<V> value) throws UnsupportedEncodingException {
        FileIterator iteartor = null;
        HashMap<K, V> hm = null;
        try {
            iteartor = IOUtil.instanceFileIterator(path, charEncoding);
            hm = new HashMap<K, V>();
            String[] split = null;
            int index = 0;
            while (iteartor.hasNext()) {
                ++index;
                String readLine = iteartor.next();
                split = readLine.split(TABLE);
                if (split.length < 2) {
                    LOG.error(path + " line:" + index + " has err :" + readLine + " err to load !");
                    continue;
                }
                hm.put(ObjConver.conversion(split[0], key), ObjConver.conversion(split[1], value));
            }
        }
        finally {
            iteartor.close();
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> HashMap<K, V> loadMap(InputStream is, String charEncoding, Class<K> key, Class<V> value) throws UnsupportedEncodingException {
        FileIterator iteartor = null;
        HashMap<K, V> hm = null;
        try {
            iteartor = IOUtil.instanceFileIterator(is, charEncoding);
            hm = new HashMap<K, V>();
            String[] split = null;
            int index = 0;
            while (iteartor.hasNext()) {
                ++index;
                String readLine = iteartor.next();
                split = readLine.split(TABLE);
                if (split.length < 2) {
                    LOG.error(" line:" + index + " has err :" + readLine + " err to load !");
                    continue;
                }
                hm.put(ObjConver.conversion(split[0], key), ObjConver.conversion(split[1], value));
            }
        }
        finally {
            iteartor.close();
        }
        return hm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void writeMap(Map<K, V> hm, String path, String charEncoding) throws IOException {
        Iterator<Map.Entry<K, V>> iterator = hm.entrySet().iterator();
        FileOutputStream fos = null;
        Map.Entry<K, V> next = null;
        try {
            fos = new FileOutputStream(path);
            while (iterator.hasNext()) {
                next = iterator.next();
                fos.write(next.getKey().toString().getBytes(charEncoding));
                fos.write(TABBYTE);
                fos.write(next.getValue().toString().getBytes(charEncoding));
                fos.write(LINEBYTE);
            }
            fos.flush();
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeList(List<T> list, String path, String charEncoding) throws IOException {
        Iterator<T> iterator = list.iterator();
        FileOutputStream fos = null;
        Object next = null;
        try {
            fos = new FileOutputStream(path);
            while (iterator.hasNext()) {
                next = iterator.next();
                fos.write(next.toString().getBytes(charEncoding));
                fos.write(LINEBYTE);
            }
            fos.flush();
        }
        finally {
            fos.close();
        }
    }

    public static List<String> readFile2List(String path, String charEncoding) throws UnsupportedEncodingException, FileNotFoundException {
        return IOUtil.readFile2List(IOUtil.getReader(path, charEncoding));
    }

    public static List<String> readFile2List(File file, String charEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        return IOUtil.readFile2List(IOUtil.getReader(file, charEncoding));
    }

    public static List<String> readFile2List(InputStream inputStream, String charEncoding) throws UnsupportedEncodingException {
        return IOUtil.readFile2List(IOUtil.getReader(inputStream, charEncoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(BufferedReader br) {
        ArrayList<String> all = new ArrayList<String>();
        String temp = null;
        try {
            while ((temp = br.readLine()) != null) {
                all.add(temp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return all;
    }
}

