/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.queryrender;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static String getSPARQLQueryString(Value theValue) {
        StringBuilder aBuffer = new StringBuilder();
        if (theValue instanceof URI) {
            URI aURI = (URI)theValue;
            aBuffer.append("<").append(aURI.toString()).append(">");
        } else if (theValue instanceof BNode) {
            aBuffer.append("_:").append(((BNode)theValue).getID());
        } else if (theValue instanceof Literal) {
            Literal aLit = (Literal)theValue;
            aBuffer.append("\"\"\"").append(RenderUtils.escape(aLit.getLabel())).append("\"\"\"").append(aLit.getLanguage() != null ? "@" + aLit.getLanguage() : "");
            if (aLit.getDatatype() != null) {
                aBuffer.append("^^<").append(aLit.getDatatype().toString()).append(">");
            }
        }
        return aBuffer.toString();
    }

    public static String getSerqlQueryString(Value theValue) {
        StringBuilder aBuffer = new StringBuilder();
        if (theValue instanceof URI) {
            URI aURI = (URI)theValue;
            aBuffer.append("<").append(aURI.toString()).append(">");
        } else if (theValue instanceof BNode) {
            aBuffer.append("_:").append(((BNode)theValue).getID());
        } else if (theValue instanceof Literal) {
            Literal aLit = (Literal)theValue;
            aBuffer.append("\"").append(RenderUtils.escape(aLit.getLabel())).append("\"").append(aLit.getLanguage() != null ? "@" + aLit.getLanguage() : "");
            if (aLit.getDatatype() != null) {
                aBuffer.append("^^<").append(aLit.getDatatype().toString()).append(">");
            }
        }
        return aBuffer.toString();
    }

    public static String escape(String theString) {
        theString = theString.replaceAll("\"", "\\\\\"");
        StringBuffer aBuffer = new StringBuffer();
        Matcher aMatcher = Pattern.compile("\\\\([^tnrbf\"'\\\\])").matcher(theString);
        while (aMatcher.find()) {
            aMatcher.appendReplacement(aBuffer, String.format("\\\\\\\\%s", aMatcher.group(1)));
        }
        aMatcher.appendTail(aBuffer);
        return aBuffer.toString();
    }
}

