/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.queryrender.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.Distinct;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Extension;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.Filter;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.MultiProjection;
import org.openrdf.query.algebra.Order;
import org.openrdf.query.algebra.OrderElem;
import org.openrdf.query.algebra.Projection;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Reduced;
import org.openrdf.query.algebra.Slice;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;
import org.openrdf.query.algebra.helpers.VarNameCollector;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.queryrender.builder.Group;
import org.openrdf.queryrender.builder.GroupBuilder;
import org.openrdf.queryrender.builder.QueryBuilder;

public class AbstractQueryBuilder<T extends ParsedQuery>
implements QueryBuilder<T> {
    protected List<StatementPattern> mProjectionPatterns = new ArrayList<StatementPattern>();
    protected List<String> mProjectionVars = new ArrayList<String>();
    private List<Group> mQueryAtoms = new ArrayList<Group>();
    private List<OrderElem> mOrderByElems = new ArrayList<OrderElem>();
    private int mLimit = -1;
    private int mOffset = -1;
    private boolean mDistinct = false;
    private boolean mReduced = false;
    private Set<URI> mFrom = new HashSet<URI>();
    private Set<URI> mFromNamed = new HashSet<URI>();
    private T mQuery;

    AbstractQueryBuilder(T theQuery) {
        this.mQuery = theQuery;
    }

    @Override
    public void reset() {
        this.mReduced = false;
        this.mDistinct = false;
        this.mOffset = -1;
        this.mLimit = -1;
        this.mProjectionVars.clear();
        this.mQueryAtoms.clear();
        this.mProjectionPatterns.clear();
    }

    @Override
    public T query() {
        VarNameCollector aCollector;
        Slice aRoot = null;
        Slice aCurr = null;
        if (this.mLimit != -1 || this.mOffset != -1) {
            Slice aSlice = new Slice();
            if (this.mLimit != -1) {
                aSlice.setLimit((long)this.mLimit);
            }
            if (this.mOffset != -1) {
                aSlice.setOffset((long)this.mOffset);
            }
            aRoot = aCurr = aSlice;
        }
        if (this.mOrderByElems != null && !this.mOrderByElems.isEmpty()) {
            Order aOrder = new Order();
            aOrder.addElements(this.mOrderByElems);
            if (aRoot == null) {
                aRoot = aCurr = aOrder;
            } else {
                aCurr.setArg((TupleExpr)aOrder);
                aCurr = aOrder;
            }
        }
        if (this.mDistinct) {
            Distinct aDistinct = new Distinct();
            if (aRoot == null) {
                aRoot = aCurr = aDistinct;
            } else {
                aCurr.setArg((TupleExpr)aDistinct);
                aCurr = aDistinct;
            }
        }
        if (this.mReduced) {
            Reduced aReduced = new Reduced();
            if (aRoot == null) {
                aRoot = aCurr = aReduced;
            } else {
                aCurr.setArg((TupleExpr)aReduced);
                aCurr = aReduced;
            }
        }
        TupleExpr aJoin = this.join();
        if (this.mQuery instanceof ParsedTupleQuery && this.mProjectionVars.isEmpty()) {
            aCollector = new VarNameCollector();
            aJoin.visit((QueryModelVisitor)aCollector);
            this.mProjectionVars.addAll(aCollector.getVarNames());
        } else if (this.mQuery instanceof ParsedGraphQuery && this.mProjectionPatterns.isEmpty()) {
            aCollector = new StatementPatternCollector();
            aJoin.visit((QueryModelVisitor)aCollector);
            this.mProjectionPatterns.addAll(aCollector.getStatementPatterns());
        }
        UnaryTupleOperator aProjection = this.projection();
        if (aRoot == null) {
            aRoot = aCurr = aProjection;
        } else {
            aCurr.setArg((TupleExpr)aProjection);
        }
        aCurr = aProjection.getArg() == null ? aProjection : (UnaryTupleOperator)aProjection.getArg();
        if (aJoin != null) {
            aCurr.setArg(aJoin);
        }
        this.mQuery.setTupleExpr((TupleExpr)aRoot);
        if (!this.mFrom.isEmpty() || !this.mFromNamed.isEmpty()) {
            DatasetImpl aDataset = new DatasetImpl();
            for (URI aFrom : this.mFrom) {
                aDataset.addDefaultGraph(aFrom);
            }
            for (URI aFrom : this.mFromNamed) {
                aDataset.addNamedGraph(aFrom);
            }
            this.mQuery.setDataset((Dataset)aDataset);
        }
        return this.mQuery;
    }

    @Override
    public QueryBuilder<T> fromNamed(URI theURI) {
        this.mFromNamed.add(theURI);
        return this;
    }

    @Override
    public QueryBuilder<T> from(URI theURI) {
        this.mFrom.add(theURI);
        return this;
    }

    @Override
    public QueryBuilder<T> distinct() {
        if (this.isSelect()) {
            this.mDistinct = true;
        }
        return this;
    }

    @Override
    public QueryBuilder<T> reduced() {
        this.mReduced = true;
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionVar(String ... theNames) {
        if (this.isSelect()) {
            this.mProjectionVars.addAll(Arrays.asList(theNames));
        }
        return this;
    }

    private boolean isConstruct() {
        return this.mQuery instanceof ParsedGraphQuery;
    }

    private boolean isSelect() {
        return this.mQuery instanceof ParsedTupleQuery;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(String theSubj, String thePred, String theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), new Var(thePred), new Var(theObj)));
        }
        return this;
    }

    public QueryBuilder<T> addProjectionStatement(String theSubj, Value thePred, Value theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), GroupBuilder.valueToVar(thePred), GroupBuilder.valueToVar(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(String theSubj, String thePred, Value theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), new Var(thePred), GroupBuilder.valueToVar(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(String theSubj, URI thePred, Value theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), GroupBuilder.valueToVar((Value)thePred), GroupBuilder.valueToVar(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(URI theSubj, String thePred, String theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(GroupBuilder.valueToVar((Value)theSubj), new Var(thePred), new Var(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(URI theSubj, URI thePred, String theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(GroupBuilder.valueToVar((Value)theSubj), GroupBuilder.valueToVar((Value)thePred), new Var(theObj)));
        }
        return this;
    }

    @Override
    public QueryBuilder<T> addProjectionStatement(String theSubj, URI thePred, String theObj) {
        if (this.isConstruct()) {
            this.mProjectionPatterns.add(new StatementPattern(new Var(theSubj), GroupBuilder.valueToVar((Value)thePred), new Var(theObj)));
        }
        return this;
    }

    private TupleExpr join() {
        if (this.mQueryAtoms.isEmpty()) {
            throw new RuntimeException("Can't have an empty or missing join.");
        }
        if (this.mQueryAtoms.size() == 1) {
            return this.mQueryAtoms.get(0).expr();
        }
        return this.groupAsJoin(this.mQueryAtoms);
    }

    private UnaryTupleOperator projection() {
        if (!this.mProjectionPatterns.isEmpty()) {
            return this.multiProjection();
        }
        TupleExpr aExt = null;
        ProjectionElemList aList = new ProjectionElemList();
        for (String aVar : this.mProjectionVars) {
            aList.addElement(new ProjectionElem(aVar));
        }
        Projection aProjection = new Projection();
        aProjection.setProjectionElemList(aList);
        if (aExt != null) {
            aProjection.setArg(aExt);
        }
        return aProjection;
    }

    private UnaryTupleOperator multiProjection() {
        MultiProjection aProjection = new MultiProjection();
        Extension aExt = null;
        for (StatementPattern aPattern : this.mProjectionPatterns) {
            ProjectionElemList aList = new ProjectionElemList();
            aList.addElement(new ProjectionElem(aPattern.getSubjectVar().getName(), "subject"));
            aList.addElement(new ProjectionElem(aPattern.getPredicateVar().getName(), "predicate"));
            aList.addElement(new ProjectionElem(aPattern.getObjectVar().getName(), "object"));
            if (aPattern.getSubjectVar().hasValue()) {
                if (aExt == null) {
                    aExt = new Extension();
                }
                aExt.addElements(new ExtensionElem[]{new ExtensionElem((ValueExpr)new ValueConstant(aPattern.getSubjectVar().getValue()), aPattern.getSubjectVar().getName())});
            }
            if (aPattern.getPredicateVar().hasValue()) {
                if (aExt == null) {
                    aExt = new Extension();
                }
                aExt.addElements(new ExtensionElem[]{new ExtensionElem((ValueExpr)new ValueConstant(aPattern.getPredicateVar().getValue()), aPattern.getPredicateVar().getName())});
            }
            if (aPattern.getObjectVar().hasValue()) {
                if (aExt == null) {
                    aExt = new Extension();
                }
                aExt.addElements(new ExtensionElem[]{new ExtensionElem((ValueExpr)new ValueConstant(aPattern.getObjectVar().getValue()), aPattern.getObjectVar().getName())});
            }
            aProjection.addProjection(aList);
        }
        if (aExt != null) {
            aProjection.setArg(aExt);
        }
        return aProjection;
    }

    @Override
    public GroupBuilder<T, QueryBuilder<T>> group() {
        return new GroupBuilder(this, false, null);
    }

    @Override
    public GroupBuilder<T, QueryBuilder<T>> optional() {
        return new GroupBuilder(this, true, null);
    }

    @Override
    public QueryBuilder<T> limit(int theLimit) {
        this.mLimit = theLimit;
        return this;
    }

    @Override
    public QueryBuilder<T> offset(int theOffset) {
        this.mOffset = theOffset;
        return this;
    }

    public QueryBuilder<T> addGroup(Group theGroup) {
        this.mQueryAtoms.add(theGroup);
        return this;
    }

    public QueryBuilder<T> removeGroup(Group theGroup) {
        this.mQueryAtoms.remove(theGroup);
        return this;
    }

    private TupleExpr groupAsJoin(List<Group> theList) {
        Join aJoin = new Join();
        Filter aFilter = null;
        for (Group aGroup : theList) {
            TupleExpr aExpr = aGroup.expr();
            if (aExpr == null) continue;
            if (aExpr instanceof Filter && (((Filter)aExpr).getArg() == null || ((Filter)aExpr).getArg() instanceof EmptySet)) {
                if (aFilter == null) {
                    aFilter = (Filter)aExpr;
                    continue;
                }
                aFilter.setCondition((ValueExpr)new And(aFilter.getCondition(), ((Filter)aExpr).getCondition()));
                continue;
            }
            if (aFilter != null) {
                aFilter.setArg(aExpr);
                aExpr = aFilter;
                aFilter = null;
            }
            if (aGroup.isOptional()) {
                LeftJoin lj = new LeftJoin();
                TupleExpr aLeft = this.joinOrExpr((BinaryTupleOperator)aJoin);
                if (aLeft != null) {
                    lj.setLeftArg(aLeft);
                    lj.setRightArg(aExpr);
                    aJoin = lj;
                    continue;
                }
            }
            if (aJoin.getLeftArg() == null) {
                aJoin.setLeftArg(aExpr);
                continue;
            }
            if (aJoin.getRightArg() == null) {
                aJoin.setRightArg(aExpr);
                continue;
            }
            Join aNewJoin = new Join();
            aNewJoin.setLeftArg((TupleExpr)aJoin);
            aNewJoin.setRightArg(aExpr);
            aJoin = aNewJoin;
        }
        TupleExpr aExpr = this.joinOrExpr((BinaryTupleOperator)aJoin);
        if (aFilter != null) {
            aFilter.setArg(aExpr);
            aExpr = aFilter;
        }
        return aExpr;
    }

    private TupleExpr joinOrExpr(BinaryTupleOperator theExpr) {
        if (theExpr.getLeftArg() != null && theExpr.getRightArg() == null) {
            return theExpr.getLeftArg();
        }
        if (theExpr.getLeftArg() == null && theExpr.getRightArg() != null) {
            return theExpr.getRightArg();
        }
        if (theExpr.getLeftArg() == null && theExpr.getRightArg() == null) {
            return null;
        }
        return theExpr;
    }

    @Override
    public QueryBuilder<T> orderBy(String ... theNames) {
        return this.orderByAsc(theNames);
    }

    @Override
    public QueryBuilder<T> orderByAsc(String ... theNames) {
        if (theNames != null) {
            for (String aName : theNames) {
                this.mOrderByElems.add(new OrderElem((ValueExpr)new Var(aName), true));
            }
        }
        return this;
    }

    @Override
    public QueryBuilder<T> orderByDesc(String ... theNames) {
        if (theNames != null) {
            for (String aName : theNames) {
                this.mOrderByElems.add(new OrderElem((ValueExpr)new Var(aName), false));
            }
        }
        return this;
    }
}

