/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.queryrender.builder;

import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.queryrender.builder.AbstractQueryBuilder;
import org.openrdf.queryrender.builder.GroupBuilder;
import org.openrdf.queryrender.builder.QueryBuilder;

public class QueryBuilderFactory {
    public static QueryBuilder<ParsedBooleanQuery> ask() {
        return new AbstractQueryBuilder<ParsedBooleanQuery>(new ParsedBooleanQuery());
    }

    public static QueryBuilder<ParsedTupleQuery> select() {
        return new AbstractQueryBuilder<ParsedTupleQuery>(new ParsedTupleQuery());
    }

    public static QueryBuilder<ParsedTupleQuery> select(String ... theProjectionVars) {
        AbstractQueryBuilder<ParsedTupleQuery> aBuilder = new AbstractQueryBuilder<ParsedTupleQuery>(new ParsedTupleQuery());
        aBuilder.addProjectionVar(theProjectionVars);
        return aBuilder;
    }

    public static QueryBuilder<ParsedGraphQuery> construct() {
        return new AbstractQueryBuilder<ParsedGraphQuery>(new ParsedGraphQuery());
    }

    public static QueryBuilder<ParsedGraphQuery> describe(Resource ... theValues) {
        return QueryBuilderFactory.describe(null, theValues);
    }

    public static QueryBuilder<ParsedGraphQuery> describe(String[] theVars, Resource ... theValues) {
        AbstractQueryBuilder<ParsedGraphQuery> aBuilder = new AbstractQueryBuilder<ParsedGraphQuery>(new ParsedGraphQuery());
        aBuilder.reduced();
        aBuilder.addProjectionVar("descr_subj", "descr_pred", "descr_obj");
        GroupBuilder aGroup = aBuilder.group();
        if (theVars != null) {
            for (String string : theVars) {
                Var aVarObj = new Var(string);
                aVarObj.setAnonymous(true);
                aGroup.filter().or((ValueExpr)new SameTerm((ValueExpr)aVarObj, (ValueExpr)new Var("descr_subj")), (ValueExpr)new SameTerm((ValueExpr)aVarObj, (ValueExpr)new Var("descr_obj")));
            }
        }
        if (theValues != null) {
            for (String string : theValues) {
                Var aSubjVar = new Var("descr_subj");
                aSubjVar.setAnonymous(true);
                Var aObjVar = new Var("descr_obj");
                aObjVar.setAnonymous(true);
                aGroup.filter().or((ValueExpr)new SameTerm((ValueExpr)new ValueConstant((Value)string), (ValueExpr)aSubjVar), (ValueExpr)new SameTerm((ValueExpr)new ValueConstant((Value)string), (ValueExpr)aObjVar));
            }
        }
        aGroup.atom("descr_subj", "descr_pred", "descr_obj");
        return aBuilder;
    }
}

