/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.List;
import java.util.Map;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.config.client.PropertiesConstants;
import org.pac4j.core.client.Client;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.AzureAdClient;
import org.pac4j.oidc.client.GoogleOidcClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;

public class OidcClientBuilder
extends AbstractBuilder
implements PropertiesConstants {
    public OidcClientBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreateOidcClient(List<Client> clients) {
        for (int i = 0; i <= 10; ++i) {
            String type;
            String clientAuthenticationMethod;
            String maxClockSkew;
            String jwsAlgo;
            String useNonce;
            String discoveryUri;
            String id = this.getProperty("oidc.id", i);
            String secret = this.getProperty("oidc.secret", i);
            if (!CommonHelper.isNotBlank((String)id) || !CommonHelper.isNotBlank((String)secret)) continue;
            OidcConfiguration configuration = new OidcConfiguration();
            configuration.setClientId(id);
            configuration.setSecret(secret);
            String scope = this.getProperty("oidc.scope", i);
            if (CommonHelper.isNotBlank((String)scope)) {
                configuration.setScope(scope);
            }
            if (CommonHelper.isNotBlank((String)(discoveryUri = this.getProperty("oidc.discoveryUri", i)))) {
                configuration.setDiscoveryURI(discoveryUri);
            }
            if (CommonHelper.isNotBlank((String)(useNonce = this.getProperty("oidc.useNonce", i)))) {
                configuration.setUseNonce(Boolean.parseBoolean(useNonce));
            }
            if (CommonHelper.isNotBlank((String)(jwsAlgo = this.getProperty("oidc.preferredJwsAlgorithm", i)))) {
                configuration.setPreferredJwsAlgorithm(JWSAlgorithm.parse((String)jwsAlgo));
            }
            if (CommonHelper.isNotBlank((String)(maxClockSkew = this.getProperty("oidc.maxClockSkew", i)))) {
                configuration.setMaxClockSkew(Integer.parseInt(maxClockSkew));
            }
            if (CommonHelper.isNotBlank((String)(clientAuthenticationMethod = this.getProperty("oidc.clientAuthenticationMethod", i)))) {
                configuration.setClientAuthenticationMethod(ClientAuthenticationMethod.parse((String)clientAuthenticationMethod));
            }
            String key1 = this.getProperty("oidc.customParamKey1", i);
            String value1 = this.getProperty("oidc.customParamValue1", i);
            if (CommonHelper.isNotBlank((String)key1)) {
                configuration.addCustomParam(key1, value1);
            }
            String key2 = this.getProperty("oidc.customParamKey2", i);
            String value2 = this.getProperty("oidc.customParamValue2", i);
            if (CommonHelper.isNotBlank((String)key2)) {
                configuration.addCustomParam(key2, value2);
            }
            Object oidcClient = "azure".equalsIgnoreCase(type = this.getProperty("oidc.type", i)) ? new AzureAdClient(configuration) : ("google".equalsIgnoreCase(type) ? new GoogleOidcClient(configuration) : new OidcClient(configuration));
            if (i != 0) {
                oidcClient.setName(this.concat(oidcClient.getName(), i));
            }
            clients.add((Client)oidcClient);
        }
    }
}

