/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;

public class FromAttributesAuthorizationGenerator<U extends CommonProfile>
implements AuthorizationGenerator<U> {
    private final Collection<String> roleAttributes;
    private final Collection<String> permissionAttributes;
    private String splitChar = ",";

    public FromAttributesAuthorizationGenerator(Collection<String> roleAttributes, Collection<String> permissionAttributes) {
        this.roleAttributes = roleAttributes;
        this.permissionAttributes = permissionAttributes;
    }

    public FromAttributesAuthorizationGenerator(String[] roleAttributes, String[] permissionAttributes) {
        this.roleAttributes = roleAttributes != null ? Arrays.asList(roleAttributes) : null;
        this.permissionAttributes = permissionAttributes != null ? Arrays.asList(permissionAttributes) : null;
    }

    @Override
    public U generate(WebContext context, U profile) {
        this.generateAuth(profile, this.roleAttributes, true);
        this.generateAuth(profile, this.permissionAttributes, false);
        return profile;
    }

    private void generateAuth(U profile, Iterable<String> attributes, boolean isRole) {
        if (attributes == null) {
            return;
        }
        for (String attribute : attributes) {
            Object value = ((UserProfile)profile).getAttribute(attribute);
            if (value == null) continue;
            if (value instanceof String) {
                StringTokenizer st = new StringTokenizer((String)value, this.splitChar);
                while (st.hasMoreTokens()) {
                    this.addRoleOrPermissionToProfile(profile, st.nextToken(), isRole);
                }
                continue;
            }
            if (value.getClass().isArray() && value.getClass().getComponentType().isAssignableFrom(String.class)) {
                for (Object item : (Object[])value) {
                    this.addRoleOrPermissionToProfile(profile, item.toString(), isRole);
                }
                continue;
            }
            if (!Collection.class.isAssignableFrom(value.getClass())) continue;
            for (Object item : (Collection)value) {
                if (!item.getClass().isAssignableFrom(String.class)) continue;
                this.addRoleOrPermissionToProfile(profile, item.toString(), isRole);
            }
        }
    }

    private void addRoleOrPermissionToProfile(U profile, String value, boolean isRole) {
        if (isRole) {
            ((UserProfile)profile).addRole(value);
        } else {
            ((UserProfile)profile).addPermission(value);
        }
    }

    public String getSplitChar() {
        return this.splitChar;
    }

    public void setSplitChar(String splitChar) {
        this.splitChar = splitChar;
    }
}

