/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.context.session;

import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.session.J2EProvidedSessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class J2ESessionStore
implements SessionStore<J2EContext> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected HttpSession getHttpSession(J2EContext context) {
        return context.getRequest().getSession();
    }

    @Override
    public String getOrCreateSessionId(J2EContext context) {
        return this.getHttpSession(context).getId();
    }

    @Override
    public Object get(J2EContext context, String key) {
        return this.getHttpSession(context).getAttribute(key);
    }

    @Override
    public void set(J2EContext context, String key, Object value) {
        this.getHttpSession(context).setAttribute(key, value);
    }

    @Override
    public boolean destroySession(J2EContext context) {
        this.getHttpSession(context).invalidate();
        return true;
    }

    @Override
    public Object getTrackableSession(J2EContext context) {
        return this.getHttpSession(context);
    }

    @Override
    public SessionStore<J2EContext> buildFromTrackableSession(J2EContext context, Object trackableSession) {
        if (trackableSession != null) {
            return new J2EProvidedSessionStore((HttpSession)trackableSession);
        }
        return null;
    }

    @Override
    public boolean renewSession(J2EContext context) {
        HttpServletRequest request = context.getRequest();
        HttpSession session = request.getSession();
        this.logger.debug("Discard old session: {}", (Object)session.getId());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Collections.list(session.getAttributeNames()).forEach(k -> attributes.put((String)k, session.getAttribute(k)));
        session.invalidate();
        HttpSession newSession = request.getSession(true);
        this.logger.debug("And copy all data to the new one: {}", (Object)newSession.getId());
        attributes.forEach((k, v) -> newSession.setAttribute(k, v));
        return true;
    }
}

