/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserProfile
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 9020114478664816338L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String id;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final transient String SEPARATOR = "#";
    private boolean isRemembered = false;
    private Set<String> roles = new HashSet<String>();
    private Set<String> permissions = new HashSet<String>();
    private String clientName;
    private String linkedId;

    public void build(Object id, Map<String, Object> attributes) {
        this.setId(id);
        this.addAttributes(attributes);
    }

    public void addAttribute(String key, Object value) {
        if (value != null) {
            this.logger.debug("adding => key: {} / value: {} / {}", new Object[]{key, value, value.getClass()});
            this.attributes.put(key, ProfileHelper.getInternalAttributeHandler().prepare(value));
        }
    }

    public void addAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.addAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void removeAttribute(String key) {
        CommonHelper.assertNotNull("key", key);
        this.attributes.remove(key);
    }

    public void setId(Object id) {
        CommonHelper.assertNotNull("id", id);
        String sId = id.toString();
        String type = this.getClass().getName() + SEPARATOR;
        if (sId.startsWith(type)) {
            sId = sId.substring(type.length());
        }
        this.logger.debug("identifier: {}", (Object)sId);
        this.id = sId;
    }

    public String getId() {
        return this.id;
    }

    public String getTypedId() {
        return this.getClass().getName() + SEPARATOR + this.id;
    }

    public Map<String, Object> getAttributes() {
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entries : this.attributes.entrySet()) {
            String key = entries.getKey();
            Object value = this.getAttribute(key);
            newAttributes.put(key, value);
        }
        return Collections.unmodifiableMap(newAttributes);
    }

    public Object getAttribute(String name) {
        return ProfileHelper.getInternalAttributeHandler().restore(this.attributes.get(name));
    }

    public boolean containsAttribute(String name) {
        CommonHelper.assertNotNull("name", name);
        return this.attributes.containsKey(name);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        Object attribute = this.getAttribute(name);
        if (attribute == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(attribute.getClass())) {
            throw new ClassCastException("Attribute [" + name + " is of type " + attribute.getClass() + " when we were expecting " + clazz);
        }
        return (T)attribute;
    }

    public void addRole(String role) {
        CommonHelper.assertNotBlank("role", role);
        this.roles.add(role);
    }

    public void addRoles(Collection<String> roles) {
        CommonHelper.assertNotNull("roles", roles);
        this.roles.addAll(roles);
    }

    public void addRoles(Set<String> roles) {
        CommonHelper.assertNotNull("roles", roles);
        this.roles.addAll(roles);
    }

    public void addPermission(String permission) {
        CommonHelper.assertNotBlank("permission", permission);
        this.permissions.add(permission);
    }

    public void addPermissions(Collection<String> permissions) {
        CommonHelper.assertNotNull("permissions", permissions);
        this.permissions.addAll(permissions);
    }

    public void setRemembered(boolean rme) {
        this.isRemembered = rme;
    }

    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public boolean isRemembered() {
        return this.isRemembered;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "id", this.id, "attributes", this.attributes, "roles", this.roles, "permissions", this.permissions, "isRemembered", this.isRemembered, "clientName", this.clientName, "linkedId", this.linkedId);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.attributes);
        out.writeBoolean(this.isRemembered);
        out.writeObject(this.roles);
        out.writeObject(this.permissions);
        out.writeObject(this.clientName);
        out.writeObject(this.linkedId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)in.readObject();
        this.attributes = (Map)in.readObject();
        this.isRemembered = in.readBoolean();
        this.roles = (Set)in.readObject();
        this.permissions = (Set)in.readObject();
        this.clientName = (String)in.readObject();
        this.linkedId = (String)in.readObject();
    }

    public void clearSensitiveData() {
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getLinkedId() {
        return this.linkedId;
    }

    public void setLinkedId(String linkedId) {
        this.linkedId = linkedId;
    }
}

