/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProfileDefinition<P extends CommonProfile> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<String> primaries = new ArrayList<String>();
    private final List<String> secondaries = new ArrayList<String>();
    private final Map<String, AttributeConverter<? extends Object>> converters = new HashMap<String, AttributeConverter<? extends Object>>();
    protected Function<Object[], P> newProfile = parameters -> new CommonProfile();

    public P newProfile(Object ... parameters) {
        return (P)((CommonProfile)this.newProfile.apply(parameters));
    }

    public void convertAndAdd(CommonProfile profile, String name, Object value) {
        if (value != null) {
            AttributeConverter<? extends Object> converter = this.converters.get(name);
            if (converter != null) {
                Object convertedValue = converter.convert(value);
                if (convertedValue != null) {
                    this.logger.debug("converted to => key: {} / value: {} / {}", new Object[]{name, convertedValue, convertedValue.getClass()});
                    profile.addAttribute(name, convertedValue);
                }
            } else {
                Object convertedValue = value;
                this.logger.debug("no conversion => key: {} / value: {} / {}", new Object[]{name, convertedValue, convertedValue.getClass()});
                profile.addAttribute(name, convertedValue);
            }
        }
    }

    public void convertAndAdd(CommonProfile profile, Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.convertAndAdd(profile, key, value);
            }
        }
    }

    protected void setProfileFactory(Function<Object[], P> profileFactory) {
        CommonHelper.assertNotNull("profileFactory", profileFactory);
        this.newProfile = profileFactory;
    }

    protected void primary(String name, AttributeConverter<? extends Object> converter) {
        this.primaries.add(name);
        this.converters.put(name, converter);
    }

    protected void secondary(String name, AttributeConverter<? extends Object> converter) {
        this.secondaries.add(name);
        this.converters.put(name, converter);
    }

    public List<String> getPrimaryAttributes() {
        return this.primaries;
    }

    public List<String> getSecondaryAttributes() {
        return this.secondaries;
    }

    protected Map<String, AttributeConverter<? extends Object>> getConverters() {
        return this.converters;
    }
}

