/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.StateApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.Google2JsonExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.Verb;
import org.scribe.utils.OAuthEncoder;

public class GoogleApi20
extends StateApi20 {
    private static final String AUTHORIZATION_URL = "https://accounts.google.com/o/oauth2/auth?client_id=%s&redirect_uri=%s&scope=%s&response_type=code&state=%s";

    @Override
    public String getAuthorizationUrl(OAuthConfig config, String state) {
        return String.format(AUTHORIZATION_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)config.getScope()), state);
    }

    public String getAccessTokenEndpoint() {
        return "https://accounts.google.com/o/oauth2/token";
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new Google2JsonExtractor();
    }
}

