/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.FacebookApi;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.facebook.FacebookProfile;
import org.pac4j.oauth.profile.facebook.FacebookProfileCreator;
import org.pac4j.oauth.profile.facebook.FacebookProfileDefinition;

public class FacebookClient
extends OAuth20Client<FacebookProfile> {
    public static final String DEFAULT_FIELDS = "id,name,first_name,middle_name,last_name,gender,locale,languages,link,third_party_id,timezone,updated_time,verified,about,birthday,education,email,hometown,interested_in,location,political,favorite_athletes,favorite_teams,quotes,relationship_status,religion,significant_other,website,work";
    protected String fields = "id,name,first_name,middle_name,last_name,gender,locale,languages,link,third_party_id,timezone,updated_time,verified,about,birthday,education,email,hometown,interested_in,location,political,favorite_athletes,favorite_teams,quotes,relationship_status,religion,significant_other,website,work";
    public static final String DEFAULT_SCOPE = "user_likes,user_about_me,user_birthday,user_education_history,email,user_hometown,user_relationship_details,user_location,user_religion_politics,user_relationships,user_website,user_work_history";
    protected String scope = "user_likes,user_about_me,user_birthday,user_education_history,email,user_hometown,user_relationship_details,user_location,user_religion_politics,user_relationships,user_website,user_work_history";
    protected int limit = 0;
    protected boolean requiresExtendedToken = false;
    protected boolean useAppsecretProof = false;

    public FacebookClient() {
    }

    public FacebookClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"fields", (String)this.fields);
        this.configuration.setApi(FacebookApi.instance());
        this.configuration.setProfileDefinition(new FacebookProfileDefinition());
        this.configuration.setScope(this.scope);
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error");
            String errorReason = ctx.getRequestParameter("error_reason");
            if ("access_denied".equals(error) && "user_denied".equals(errorReason)) {
                return true;
            }
            return false;
        });
        this.configuration.setWithState(true);
        this.setConfiguration(this.configuration);
        this.defaultProfileCreator(new FacebookProfileCreator(this.configuration));
        super.clientInit(context);
    }

    public void setStateData(String stateData) {
        this.configuration.setStateData(stateData);
    }

    public String getStateData() {
        return this.configuration.getStateData();
    }

    public void setUseAppSecretProof(boolean useSecret) {
        this.useAppsecretProof = useSecret;
    }

    public boolean getUseAppSecretProof() {
        return this.useAppsecretProof;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isRequiresExtendedToken() {
        return this.requiresExtendedToken;
    }

    public void setRequiresExtendedToken(boolean requiresExtendedToken) {
        this.requiresExtendedToken = requiresExtendedToken;
    }
}

