/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.windowslive;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Arrays;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.windowslive.WindowsLiveProfile;

public class WindowsLiveProfileDefinition
extends OAuth20ProfileDefinition<WindowsLiveProfile> {
    public static final String NAME = "name";
    public static final String LAST_NAME = "last_name";
    public static final String LINK = "link";
    public static final String UPDATED_TIME = "updated_time";

    public WindowsLiveProfileDefinition() {
        super(x -> new WindowsLiveProfile());
        Arrays.stream(new String[]{NAME, LAST_NAME}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(LINK, (AttributeConverter)Converters.URL);
        this.primary(UPDATED_TIME, (AttributeConverter)Converters.DATE_TZ_GENERAL);
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, OAuth20Configuration configuration) {
        return "https://apis.live.net/v5.0/me";
    }

    @Override
    public WindowsLiveProfile extractUserProfile(String body) throws HttpAction {
        WindowsLiveProfile profile = (WindowsLiveProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.getElement(json, "id"));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd(profile, attribute, JsonHelper.getElement(json, attribute));
            }
        }
        return profile;
    }
}

