/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.redirect;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.oauth.OAuth20Service;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RedirectActionBuilder
extends InitializableWebObject
implements RedirectActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OAuth20RedirectActionBuilder.class);
    protected final OAuth20Configuration configuration;

    public OAuth20RedirectActionBuilder(OAuth20Configuration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
    }

    public RedirectAction redirect(WebContext context) throws HttpAction {
        this.init(context);
        try {
            OAuth20Service service;
            if (this.configuration.isWithState()) {
                String state = this.getStateParameter();
                logger.debug("save sessionState: {}", (Object)state);
                context.setSessionAttribute(this.configuration.getStateSessionAttributeName(), (Object)state);
                service = (OAuth20Service)this.configuration.buildService(context, state);
            } else {
                service = (OAuth20Service)this.configuration.getService();
            }
            String authorizationUrl = service.getAuthorizationUrl(this.configuration.getCustomParams());
            logger.debug("authorizationUrl: {}", (Object)authorizationUrl);
            return RedirectAction.redirect((String)authorizationUrl);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected String getStateParameter() {
        String stateData = this.configuration.getStateData();
        String stateParameter = CommonHelper.isNotBlank((String)stateData) ? stateData : CommonHelper.randomString((int)10);
        return stateParameter;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration});
    }
}

