/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.logout;

import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import java.net.URI;
import java.net.URISyntaxException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.profile.OidcProfile;

public class OidcLogoutActionBuilder<U extends OidcProfile>
extends InitializableWebObject
implements LogoutActionBuilder<U> {
    private final OidcConfiguration configuration;

    public OidcLogoutActionBuilder(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
    }

    public RedirectAction getLogoutAction(WebContext context, U currentProfile, String targetUrl) {
        this.init(context);
        String logoutUrl = this.configuration.getLogoutUrl();
        if (CommonHelper.isNotBlank((String)logoutUrl)) {
            try {
                URI endSessionEndpoint = new URI(logoutUrl);
                JWT idToken = ((OidcProfile)((Object)currentProfile)).getIdToken();
                LogoutRequest logoutRequest = CommonHelper.isNotBlank((String)targetUrl) ? new LogoutRequest(endSessionEndpoint, idToken, new URI(targetUrl), null) : new LogoutRequest(endSessionEndpoint, idToken);
                return RedirectAction.redirect((String)logoutRequest.toURI().toString());
            }
            catch (URISyntaxException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        return null;
    }
}

