/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import java.io.FileOutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.storage.EmptyStorageFactory;
import org.pac4j.saml.storage.SAMLMessageStorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.WritableResource;

public class SAML2ClientConfiguration
extends InitializableObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2ClientConfiguration.class);
    protected static final String RESOURCE_PREFIX = "resource:";
    protected static final String CLASSPATH_PREFIX = "classpath:";
    protected static final String FILE_PREFIX = "file:";
    private Resource keystoreResource;
    private String keystorePassword;
    private String privateKeyPassword;
    private Resource identityProviderMetadataResource;
    private String identityProviderEntityId;
    private String serviceProviderEntityId;
    private int maximumAuthenticationLifetime;
    private boolean forceAuth = false;
    private boolean passive = false;
    private boolean forceSignRedirectBindingAuthnRequest;
    private String comparisonType = null;
    private String destinationBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String authnContextClassRef = null;
    private String nameIdPolicyFormat = null;
    private WritableResource serviceProviderMetadataResource;
    private boolean forceServiceProviderMetadataGeneration;
    private SAMLMessageStorageFactory samlMessageStorageFactory = new EmptyStorageFactory();
    private boolean authnRequestSigned = true;
    private Collection<String> blackListedSignatureSigningAlgorithms;
    private List<String> signatureAlgorithms;
    private List<String> signatureReferenceDigestMethods;
    private String signatureCanonicalizationAlgorithm;
    private boolean wantsAssertionsSigned = true;
    private String keyStoreAlias;
    private String keyStoreType;

    public SAML2ClientConfiguration() {
    }

    public SAML2ClientConfiguration(String keystorePath, String keystorePassword, String privateKeyPassword, String identityProviderMetadataPath) {
        this(null, null, SAML2ClientConfiguration.mapPathToResource(keystorePath), keystorePassword, privateKeyPassword, SAML2ClientConfiguration.mapPathToResource(identityProviderMetadataPath), null, null);
    }

    public SAML2ClientConfiguration(Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(null, null, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null);
    }

    public SAML2ClientConfiguration(Resource keystoreResource, String keyStoreAlias, String keyStoreType, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(keyStoreAlias, keyStoreType, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null);
    }

    private SAML2ClientConfiguration(String keyStoreAlias, String keyStoreType, Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource, String identityProviderEntityId, String serviceProviderEntityId) {
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreType = keyStoreType;
        this.keystoreResource = keystoreResource;
        this.keystorePassword = keystorePassword;
        this.privateKeyPassword = privateKeyPassword;
        this.identityProviderMetadataResource = identityProviderMetadataResource;
        this.identityProviderEntityId = identityProviderEntityId;
        this.serviceProviderEntityId = serviceProviderEntityId;
    }

    protected void internalInit() {
        CommonHelper.assertNotNull((String)"keystoreResource", (Object)this.keystoreResource);
        CommonHelper.assertNotBlank((String)"keystorePassword", (String)this.keystorePassword);
        CommonHelper.assertNotBlank((String)"privateKeyPassword", (String)this.privateKeyPassword);
        CommonHelper.assertNotNull((String)"identityProviderMetadataResource", (Object)this.identityProviderMetadataResource);
        if (!this.keystoreResource.exists()) {
            if (this.keystoreResource instanceof WritableResource) {
                LOGGER.warn("Provided keystoreResource does not exist. Creating one for: {}", (Object)this.keystoreResource);
                this.createKeystore();
            } else {
                throw new TechnicalException("Provided keystoreResource does not exist and cannot be created");
            }
        }
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        this.blackListedSignatureSigningAlgorithms = new ArrayList<String>(config.getBlacklistedAlgorithms());
        this.signatureAlgorithms = new ArrayList<String>(config.getSignatureAlgorithms());
        this.signatureReferenceDigestMethods = new ArrayList<String>(config.getSignatureReferenceDigestMethods());
        this.signatureReferenceDigestMethods.remove("http://www.w3.org/2001/04/xmlenc#sha512");
        this.signatureCanonicalizationAlgorithm = config.getSignatureCanonicalizationAlgorithm();
    }

    public void setIdentityProviderMetadataResource(Resource identityProviderMetadataResource) {
        this.identityProviderMetadataResource = identityProviderMetadataResource;
    }

    public void setIdentityProviderMetadataResourceFilepath(String path) {
        this.identityProviderMetadataResource = new FileSystemResource(path);
    }

    public void setIdentityProviderMetadataResourceClasspath(String path) {
        this.identityProviderMetadataResource = new ClassPathResource(path);
    }

    public void setIdentityProviderMetadataResourceUrl(String url) {
        this.identityProviderMetadataResource = SAML2ClientConfiguration.newUrlResource(url);
    }

    public void setIdentityProviderMetadataPath(String path) {
        this.identityProviderMetadataResource = SAML2ClientConfiguration.mapPathToResource(path);
    }

    protected static UrlResource newUrlResource(String url) {
        try {
            return new UrlResource(url);
        }
        catch (MalformedURLException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected static Resource mapPathToResource(String path) {
        CommonHelper.assertNotBlank((String)"path", (String)path);
        if (path.startsWith(RESOURCE_PREFIX)) {
            return new ClassPathResource(path.substring(RESOURCE_PREFIX.length()));
        }
        if (path.startsWith(CLASSPATH_PREFIX)) {
            return new ClassPathResource(path.substring(CLASSPATH_PREFIX.length()));
        }
        if (path.startsWith("http") || path.startsWith("https")) {
            return SAML2ClientConfiguration.newUrlResource(path);
        }
        if (path.startsWith(FILE_PREFIX)) {
            return new FileSystemResource(path.substring(FILE_PREFIX.length()));
        }
        return new FileSystemResource(path);
    }

    public Resource getIdentityProviderMetadataResource() {
        return this.identityProviderMetadataResource;
    }

    public void setIdentityProviderEntityId(String identityProviderEntityId) {
        this.identityProviderEntityId = identityProviderEntityId;
    }

    public String getIdentityProviderEntityId() {
        return this.identityProviderEntityId;
    }

    public void setKeystoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public void setKeystoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeystoreResource(Resource keystoreResource) {
        this.keystoreResource = keystoreResource;
    }

    public void setKeystoreResourceFilepath(String path) {
        this.keystoreResource = new FileSystemResource(path);
    }

    public void setKeystoreResourceClasspath(String path) {
        this.keystoreResource = new ClassPathResource(path);
    }

    public void setKeystoreResourceUrl(String url) {
        this.keystoreResource = SAML2ClientConfiguration.newUrlResource(url);
    }

    public void setKeystorePath(String path) {
        this.keystoreResource = SAML2ClientConfiguration.mapPathToResource(path);
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setServiceProviderMetadataResource(WritableResource serviceProviderMetadataResource) {
        this.serviceProviderMetadataResource = serviceProviderMetadataResource;
    }

    public void setServiceProviderMetadataResourceFilepath(String path) {
        this.serviceProviderMetadataResource = new FileSystemResource(path);
    }

    public void setServiceProviderMetadataPath(String path) {
        Resource resource = SAML2ClientConfiguration.mapPathToResource(path);
        if (!(resource instanceof WritableResource)) {
            throw new TechnicalException(path + " must be a writable resource");
        }
        this.serviceProviderMetadataResource = (WritableResource)resource;
    }

    public void setForceServiceProviderMetadataGeneration(boolean forceServiceProviderMetadataGeneration) {
        this.forceServiceProviderMetadataGeneration = forceServiceProviderMetadataGeneration;
    }

    public WritableResource getServiceProviderMetadataResource() {
        return this.serviceProviderMetadataResource;
    }

    public void setServiceProviderEntityId(String serviceProviderEntityId) {
        this.serviceProviderEntityId = serviceProviderEntityId;
    }

    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isForceAuth() {
        return this.forceAuth;
    }

    public void setForceAuth(boolean forceAuth) {
        this.forceAuth = forceAuth;
    }

    public String getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(String comparisonType) {
        this.comparisonType = comparisonType;
    }

    public String getDestinationBindingType() {
        return this.destinationBindingType;
    }

    public void setDestinationBindingType(String destinationBindingType) {
        this.destinationBindingType = destinationBindingType;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public void setAuthnContextClassRef(String authnContextClassRef) {
        this.authnContextClassRef = authnContextClassRef;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public void setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    public int getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    public void setMaximumAuthenticationLifetime(int maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }

    public boolean isForceServiceProviderMetadataGeneration() {
        return this.forceServiceProviderMetadataGeneration;
    }

    public SAMLMessageStorageFactory getSamlMessageStorageFactory() {
        return this.samlMessageStorageFactory;
    }

    public void setSamlMessageStorageFactory(SAMLMessageStorageFactory samlMessageStorageFactory) {
        this.samlMessageStorageFactory = samlMessageStorageFactory;
    }

    public Collection<String> getBlackListedSignatureSigningAlgorithms() {
        return this.blackListedSignatureSigningAlgorithms;
    }

    public void setBlackListedSignatureSigningAlgorithms(Collection<String> blackListedSignatureSigningAlgorithms) {
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
    }

    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public List<String> getSignatureReferenceDigestMethods() {
        return this.signatureReferenceDigestMethods;
    }

    public void setSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
    }

    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalizationAlgorithm;
    }

    public void setSignatureCanonicalizationAlgorithm(String signatureCanonicalizationAlgorithm) {
        this.signatureCanonicalizationAlgorithm = signatureCanonicalizationAlgorithm;
    }

    public boolean getWantsAssertionsSigned() {
        return this.wantsAssertionsSigned;
    }

    public void setWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    public boolean isForceSignRedirectBindingAuthnRequest() {
        return this.forceSignRedirectBindingAuthnRequest;
    }

    public void setForceSignRedirectBindingAuthnRequest(boolean forceSignRedirectBindingAuthnRequest) {
        this.forceSignRedirectBindingAuthnRequest = forceSignRedirectBindingAuthnRequest;
    }

    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    protected void init(String clientName, WebContext context) {
        this.init();
    }

    private void createKeystore() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (CommonHelper.isBlank((String)this.keyStoreAlias)) {
                this.keyStoreAlias = ((Object)((Object)this)).getClass().getSimpleName();
                LOGGER.warn("Using keystore alias {}", (Object)this.keyStoreAlias);
            }
            if (CommonHelper.isBlank((String)this.keyStoreType)) {
                this.keyStoreType = KeyStore.getDefaultType();
                LOGGER.warn("Using keystore type {}", (Object)this.keyStoreType);
            }
            KeyStore ks = KeyStore.getInstance(this.keyStoreType);
            char[] password = this.keystorePassword.toCharArray();
            ks.load(null, password);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            KeyPair kp = kpg.genKeyPair();
            X509V3CertificateGenerator cert = new X509V3CertificateGenerator();
            cert.setSerialNumber(BigInteger.valueOf(1L));
            String dn = InetAddress.getLocalHost().getHostName();
            cert.setSubjectDN((X509Name)new X509Principal("CN=" + dn));
            cert.setIssuerDN((X509Name)new X509Principal("CN=" + dn));
            cert.setPublicKey(kp.getPublic());
            cert.setNotBefore(new Date());
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(1, 1);
            cert.setNotAfter(c.getTime());
            cert.setSignatureAlgorithm("SHA1WithRSA");
            PrivateKey signingKey = kp.getPrivate();
            X509Certificate certificate = cert.generate(signingKey, "BC");
            ks.setKeyEntry(this.keyStoreAlias, signingKey, password, new Certificate[]{certificate});
            try (FileOutputStream fos = new FileOutputStream(this.keystoreResource.getFile().getCanonicalPath());){
                ks.store(fos, password);
                fos.flush();
            }
            LOGGER.info("Created keystore {} with key alias {} ", (Object)this.keystoreResource.getFile().getCanonicalPath(), (Object)ks.aliases().nextElement());
        }
        catch (Exception e) {
            throw new SAMLException("Could not create keystore", e);
        }
    }
}

