/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.powermock.core.WildcardMatcher;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeferSupportingClassLoader
extends ClassLoader {
    private Map<String, Class<?>> classes;
    String[] deferPackages;
    ClassLoader deferTo;

    public void addIgnorePackage(String ... packagesToIgnore) {
        if (packagesToIgnore != null && packagesToIgnore.length > 0) {
            int previousLength = this.deferPackages.length;
            String[] newDeferPackages = new String[previousLength + packagesToIgnore.length];
            System.arraycopy(this.deferPackages, 0, newDeferPackages, 0, previousLength);
            System.arraycopy(packagesToIgnore, 0, newDeferPackages, previousLength, packagesToIgnore.length);
            this.deferPackages = newDeferPackages;
        }
    }

    public DeferSupportingClassLoader(ClassLoader classloader, String[] deferPackages) {
        this.deferTo = classloader == null ? ClassLoader.getSystemClassLoader() : classloader;
        this.classes = new HashMap();
        this.deferPackages = deferPackages;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.classes.get(name);
        if (clazz == null) {
            boolean shouldDefer = this.shouldDefer(this.deferPackages, name);
            clazz = shouldDefer ? this.deferTo.loadClass(name) : this.loadModifiedClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
        }
        this.classes.put(name, clazz);
        return clazz;
    }

    protected boolean shouldDefer(String[] packages, String name) {
        for (String packageToCheck : packages) {
            if (!this.deferConditionMatches(name, packageToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean deferConditionMatches(String name, String packageName) {
        boolean wildcardMatch = WildcardMatcher.matches(name, packageName);
        return wildcardMatch && !this.shouldLoadUnmodifiedClass(name) && (!wildcardMatch || !this.shouldModifyClass(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldIgnore(Iterable<String> packages, String name) {
        Iterable<String> iterable = packages;
        synchronized (iterable) {
            for (String ignore : packages) {
                if (!WildcardMatcher.matches(ignore, name)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldIgnore(String[] packages, String name) {
        String[] stringArray = packages;
        synchronized (packages) {
            for (String ignore : packages) {
                if (!WildcardMatcher.matches(name, ignore)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    @Override
    protected URL findResource(String name) {
        try {
            return (URL)Whitebox.invokeMethod((Object)this.deferTo, (String)"findResource", (Object[])new Object[]{name});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        try {
            return (Enumeration)Whitebox.invokeMethod((Object)this.deferTo, (String)"findResources", (Object[])new Object[]{name});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean shouldModify(Iterable<String> packages, String name) {
        return !this.shouldIgnore(packages, name);
    }

    protected abstract Class<?> loadModifiedClass(String var1) throws ClassFormatError, ClassNotFoundException;

    protected abstract boolean shouldModifyClass(String var1);

    protected abstract boolean shouldLoadUnmodifiedClass(String var1);
}

