/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.powermock.core.testlisteners.GlobalNotificationBuildSupport;
import org.powermock.core.transformers.MockTransformer;

public abstract class TestClassTransformer
implements MockTransformer {
    private final Class<?> testClass;
    private final Class<? extends java.lang.annotation.Annotation> testMethodAnnotationType;

    public static ForTestClass forTestClass(final Class<?> testClass) {
        return new ForTestClass(){

            @Override
            public ForTestClass.RemovesTestMethodAnnotation removesTestMethodAnnotation(final Class<? extends java.lang.annotation.Annotation> testMethodAnnotation) {
                return new ForTestClass.RemovesTestMethodAnnotation(){

                    @Override
                    public TestClassTransformer fromMethods(final Collection<Method> testMethodsThatRunOnOtherClassLoaders) {
                        return new TestClassTransformer(testClass, testMethodAnnotation){
                            Collection<String> methodsThatRunOnOtherClassLoaders;

                            @Override
                            boolean mustHaveTestAnnotationRemoved(CtMethod method) throws NotFoundException {
                                if (null == this.methodsThatRunOnOtherClassLoaders) {
                                    this.methodsThatRunOnOtherClassLoaders = new HashSet<String>();
                                    for (Method m : testMethodsThatRunOnOtherClassLoaders) {
                                        this.methodsThatRunOnOtherClassLoaders.add(TestClassTransformer.signatureOf(m));
                                    }
                                    testMethodsThatRunOnOtherClassLoaders.clear();
                                }
                                return this.methodsThatRunOnOtherClassLoaders.contains(TestClassTransformer.signatureOf(method));
                            }
                        };
                    }

                    @Override
                    public TestClassTransformer fromAllMethodsExcept(Method singleMethodToRunOnTargetClassLoader) {
                        final String targetMethodSignature = TestClassTransformer.signatureOf(singleMethodToRunOnTargetClassLoader);
                        return new TestClassTransformer(testClass, testMethodAnnotation){

                            @Override
                            boolean mustHaveTestAnnotationRemoved(CtMethod method) throws Exception {
                                return false == TestClassTransformer.signatureOf(method).equals(targetMethodSignature);
                            }
                        };
                    }
                };
            }
        };
    }

    private TestClassTransformer(Class<?> testClass, Class<? extends java.lang.annotation.Annotation> testMethodAnnotationType) {
        this.testClass = testClass;
        this.testMethodAnnotationType = testMethodAnnotationType;
    }

    private boolean isTestClass(CtClass clazz) {
        try {
            return Class.forName(clazz.getName(), false, this.testClass.getClassLoader()).isAssignableFrom(this.testClass);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    abstract boolean mustHaveTestAnnotationRemoved(CtMethod var1) throws Exception;

    private void removeTestMethodAnnotationFrom(CtMethod m) throws ClassNotFoundException {
        AnnotationsAttribute attr = (AnnotationsAttribute)m.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
        Annotation[] newAnnotations = new Annotation[attr.numAnnotations() - 1];
        int i = -1;
        for (Annotation a : attr.getAnnotations()) {
            if (a.getTypeName().equals(this.testMethodAnnotationType.getName())) continue;
            newAnnotations[++i] = a;
        }
        attr.setAnnotations(newAnnotations);
    }

    private void removeTestAnnotationsForTestMethodsThatRunOnOtherClassLoader(CtClass clazz) throws Exception {
        for (CtMethod m : clazz.getDeclaredMethods()) {
            if (!m.hasAnnotation(this.testMethodAnnotationType) || !this.mustHaveTestAnnotationRemoved(m)) continue;
            this.removeTestMethodAnnotationFrom(m);
        }
    }

    @Override
    public CtClass transform(CtClass clazz) throws Exception {
        if (clazz.isFrozen()) {
            clazz.defrost();
        }
        if (this.isTestClass(clazz)) {
            this.removeTestAnnotationsForTestMethodsThatRunOnOtherClassLoader(clazz);
            this.addLifeCycleNotifications(clazz);
        }
        return clazz;
    }

    private void addLifeCycleNotifications(CtClass clazz) {
        try {
            this.addClassInitializerNotification(clazz);
            this.addConstructorNotification(clazz);
        }
        catch (CannotCompileException ex) {
            throw new Error("Powermock error: " + ex.getMessage(), ex);
        }
    }

    private void addClassInitializerNotification(CtClass clazz) throws CannotCompileException {
        if (null == clazz.getClassInitializer()) {
            clazz.makeClassInitializer();
        }
        clazz.getClassInitializer().insertBefore(GlobalNotificationBuildSupport.class.getName() + ".testClassInitiated(" + clazz.getName() + ".class);");
    }

    private static boolean hasSuperClass(CtClass clazz) {
        try {
            CtClass superClazz = clazz.getSuperclass();
            return null != superClazz && false == "java.lang.Object".equals(superClazz.getName());
        }
        catch (NotFoundException noWasSuperClassFound) {
            return false;
        }
    }

    private void addConstructorNotification(CtClass clazz) throws CannotCompileException {
        String notificationCode = GlobalNotificationBuildSupport.class.getName() + ".testInstanceCreated(this);";
        boolean asFinally = false == TestClassTransformer.hasSuperClass(clazz);
        for (CtConstructor constr : clazz.getDeclaredConstructors()) {
            constr.insertAfter(notificationCode, asFinally);
        }
    }

    private static String signatureOf(Method m) {
        Class<?>[] paramTypes = m.getParameterTypes();
        String[] paramTypeNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypeNames.length; ++i) {
            paramTypeNames[i] = paramTypes[i].getSimpleName();
        }
        return TestClassTransformer.createSignature(m.getDeclaringClass().getSimpleName(), m.getReturnType().getSimpleName(), m.getName(), paramTypeNames);
    }

    private static String signatureOf(CtMethod m) throws NotFoundException {
        CtClass[] paramTypes = m.getParameterTypes();
        String[] paramTypeNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypeNames.length; ++i) {
            paramTypeNames[i] = paramTypes[i].getSimpleName();
        }
        return TestClassTransformer.createSignature(m.getDeclaringClass().getSimpleName(), m.getReturnType().getSimpleName(), m.getName(), paramTypeNames);
    }

    private static String createSignature(String testClass, String returnType, String methodName, String[] paramTypes) {
        StringBuilder builder = new StringBuilder(testClass).append('\n').append(returnType).append('\n').append(methodName);
        for (String param : paramTypes) {
            builder.append('\n').append(param);
        }
        return builder.toString();
    }

    public static interface ForTestClass {
        public RemovesTestMethodAnnotation removesTestMethodAnnotation(Class<? extends java.lang.annotation.Annotation> var1);

        public static interface RemovesTestMethodAnnotation {
            public TestClassTransformer fromMethods(Collection<Method> var1);

            public TestClassTransformer fromAllMethodsExcept(Method var1);
        }
    }
}

