/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import java.util.Enumeration;
import java.util.Vector;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.VectorJep;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;

public class MRpSurfExample {
    MatrixJep mj;
    VectorJep vj = new VectorJep();
    MRpEval mrpe = null;
    MRpCommandList[] allCommands;
    Node[] allEqns;
    Node[] vecEqns;
    MatrixVariableI xVar;
    MatrixVariableI yVar;
    Variable xVVar;
    Variable yVVar;
    int xref;
    int yref;
    double xmin = -1.0;
    double xmax = 1.0;
    double ymin = 1.0;
    double ymax = 1.0;
    int xsteps = 1000;
    int ysteps = 1000;
    static long oldTime = 0L;

    public static void main(String[] args) {
        MRpSurfExample.timePrint("\tStart");
        MRpSurfExample surf = new MRpSurfExample();
        MRpSurfExample.timePrint("\tDone init");
        try {
            surf.equationChanged("th=pi*x;phi=pi*y;f=[cos(th) cos(phi),sin(th) cos(phi),sin(phi)];");
            surf.vecEquationChanged(new String[]{"th=pi*x;", "phi=pi*y;", "[cos(th) cos(phi),sin(th) cos(phi),sin(phi)];"});
            MRpSurfExample.timePrint("\tDone parse");
            surf.calcMRPE();
            surf.mrpe.cleanUp();
            MRpSurfExample.timePrint("\tDone mrpe");
            surf.calcMJ();
            MRpSurfExample.timePrint("\tDone MJ");
            surf.calcVJ();
            MRpSurfExample.timePrint("\tDone VJ");
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public static void timePrint(String msg) {
        long time = System.currentTimeMillis();
        long timediff = time - oldTime;
        oldTime = time;
        System.out.println("" + timediff + "\t" + msg);
    }

    public MRpSurfExample() {
        this.vj.setAllowAssignment(true);
        this.vj.setAllowUndeclared(true);
        this.vj.setImplicitMul(true);
        this.vj.addComplex();
        this.vj.addStandardConstants();
        this.vj.addStandardFunctions();
        this.mj = new MatrixJep();
        this.mj.setAllowAssignment(true);
        this.mj.setAllowUndeclared(true);
        this.mj.setImplicitMul(true);
        this.mj.addComplex();
        this.mj.addStandardConstants();
        this.mj.addStandardFunctions();
        this.mj.addStandardDiffRules();
        this.mrpe = new MRpEval(this.mj);
    }

    public void equationChanged(String text) {
        this.mj.restartParser(text);
        try {
            Node n;
            Vector<MRpCommandList> coms = new Vector<MRpCommandList>();
            Vector<Node> eqns = new Vector<Node>();
            while ((n = this.mj.continueParsing()) != null) {
                Node n2 = this.mj.preprocess(n);
                MRpCommandList com = this.mrpe.compile(n2);
                coms.add(com);
                eqns.add(n2);
            }
            int i = 0;
            this.allCommands = new MRpCommandList[coms.size()];
            Enumeration en = coms.elements();
            while (en.hasMoreElements()) {
                this.allCommands[i] = (MRpCommandList)en.nextElement();
                ++i;
            }
            i = 0;
            this.allEqns = new Node[eqns.size()];
            en = eqns.elements();
            while (en.hasMoreElements()) {
                this.allEqns[i] = (Node)en.nextElement();
                ++i;
            }
            this.xVar = (MatrixVariableI)((Object)this.mj.getVar("x"));
            this.yVar = (MatrixVariableI)((Object)this.mj.getVar("y"));
            this.xref = this.mrpe.getVarRef(this.xVar);
            this.yref = this.mrpe.getVarRef(this.yVar);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
        }
    }

    public void vecEquationChanged(String[] lines) {
        try {
            this.vecEqns = new Node[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                Node n2;
                this.vecEqns[i] = n2 = this.vj.parse(lines[i]);
            }
            this.xVVar = this.vj.getVar("x");
            this.yVVar = this.vj.getVar("y");
        }
        catch (ParseException e) {
            e.getMessage();
        }
    }

    public void calcMRPE() {
        double[] topRes = null;
        for (int i = 0; i <= this.xsteps; ++i) {
            double x = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.xsteps;
            this.mrpe.setVarValue(this.xref, x);
            for (int j = 0; j <= this.ysteps; ++j) {
                double y = this.ymin + (this.ymax - this.ymin) * (double)j / (double)this.ysteps;
                this.mrpe.setVarValue(this.yref, y);
                MRpRes res = null;
                for (int k = 0; k < this.allCommands.length; ++k) {
                    res = this.mrpe.evaluate(this.allCommands[k]);
                }
                topRes = (double[])res.toArray();
            }
        }
        System.out.println("res " + (double)topRes[0] + "," + (double)topRes[1] + "," + (double)topRes[2]);
    }

    public void calcMJ() throws ParseException {
        Object[] topRes = null;
        Scaler xVal = (Scaler)this.xVar.getMValue();
        Scaler yVal = (Scaler)this.yVar.getMValue();
        this.xVar.setValidValue(true);
        this.yVar.setValidValue(true);
        for (int i = 0; i <= this.xsteps; ++i) {
            double x = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.xsteps;
            xVal.setEle(0, new Double(x));
            for (int j = 0; j <= this.ysteps; ++j) {
                double y = this.ymin + (this.ymax - this.ymin) * (double)j / (double)this.ysteps;
                yVal.setEle(0, new Double(y));
                Object res = null;
                for (int k = 0; k < this.allEqns.length; ++k) {
                    res = this.mj.evaluate(this.allEqns[k]);
                }
                topRes = ((MVector)res).getEles();
            }
        }
        System.out.println("res " + topRes[0] + "," + topRes[1] + "," + topRes[2]);
    }

    public void calcVJ() throws ParseException, Exception {
        Object[] topRes = null;
        for (int i = 0; i <= this.xsteps; ++i) {
            double x = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.xsteps;
            this.xVVar.setValue(new Double(x));
            for (int j = 0; j <= this.ysteps; ++j) {
                double y = this.ymin + (this.ymax - this.ymin) * (double)j / (double)this.ysteps;
                this.yVVar.setValue(new Double(y));
                Object res = null;
                for (int k = 0; k < this.vecEqns.length; ++k) {
                    res = this.vj.evaluate(this.vecEqns[k]);
                }
                topRes = ((MVector)res).getEles();
            }
        }
        System.out.println("res " + topRes[0] + "," + topRes[1] + "," + topRes[2]);
    }
}

