/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.base.Throwables;
import java.io.File;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public static final String IGNORE_ZOOM_SETTING = "ignoreZoomSetting";
    public static final String NATIVE_EVENTS = "nativeEvents";
    public static final String INITIAL_BROWSER_URL = "initialBrowserUrl";
    public static final String ELEMENT_SCROLL_BEHAVIOR = "elementScrollBehavior";
    public static final String UNEXPECTED_ALERT_BEHAVIOR = "unexpectedAlertBehaviour";
    public static final String ENABLE_ELEMENT_CACHE_CLEANUP = "enableElementCacheCleanup";
    public static final String BROWSER_ATTACH_TIMEOUT = "browserAttachTimeout";
    public static final String INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS = "ignoreProtectedModeSettings";
    public static final String ENABLE_PERSISTENT_HOVERING = "enablePersistentHover";
    public static final String REQUIRE_WINDOW_FOCUS = "requireWindowFocus";
    public static final String LOG_FILE = "logFile";
    public static final String LOG_LEVEL = "logLevel";
    public static final String HOST = "host";
    public static final String EXTRACT_PATH = "extractPath";
    public static final String SILENT = "silent";
    public static final String FORCE_CREATE_PROCESS = "ie.forceCreateProcessApi";
    public static final String IE_ENSURE_CLEAN_SESSION = "ie.ensureCleanSession";
    public static final String IE_USE_PRE_PROCESS_PROXY = "ie.usePerProcessProxy";
    public static final String IE_SWITCHES = "ie.browserCommandLineSwitches";
    private static final int DEFAULT_PORT = 0;
    private WindowsProxyManager proxyManager;

    public InternetExplorerDriver() {
        this(null, null, null, 0);
    }

    public InternetExplorerDriver(Capabilities capabilities) {
        this(null, null, capabilities, 0);
    }

    public InternetExplorerDriver(int port) {
        this(null, null, null, port);
    }

    public InternetExplorerDriver(InternetExplorerDriverService service) {
        this(null, service, null, 0);
    }

    public InternetExplorerDriver(InternetExplorerDriverService service, Capabilities capabilities) {
        this(null, service, capabilities, 0);
    }

    public InternetExplorerDriver(WindowsProxyManager proxy, InternetExplorerDriverService service, Capabilities capabilities, int port) {
        if (capabilities == null) {
            capabilities = DesiredCapabilities.internetExplorer();
        }
        this.proxyManager = proxy;
        if (service == null) {
            service = this.setupService(capabilities, port);
        }
        this.run(service, capabilities);
    }

    private void run(InternetExplorerDriverService service, Capabilities capabilities) {
        this.assertOnWindows();
        this.prepareProxy(capabilities);
        this.setCommandExecutor((CommandExecutor)new DriverCommandExecutor((DriverService)service));
        this.startSession(capabilities);
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64);
    }

    protected void assertOnWindows() {
        Platform current = Platform.getCurrent();
        if (!current.is(Platform.WINDOWS)) {
            throw new WebDriverException(String.format("You appear to be running %s. The IE driver only runs on Windows.", current));
        }
    }

    private InternetExplorerDriverService setupService(Capabilities caps, int port) {
        try {
            InternetExplorerDriverService.Builder builder = new InternetExplorerDriverService.Builder();
            builder.usingPort(port);
            if (caps != null) {
                Object value;
                if (caps.getCapability(LOG_FILE) != null && (value = (String)caps.getCapability(LOG_FILE)) != null) {
                    builder.withLogFile(new File((String)value));
                }
                if (caps.getCapability(LOG_LEVEL) != null && (value = (String)caps.getCapability(LOG_LEVEL)) != null) {
                    builder.withLogLevel(InternetExplorerDriverLogLevel.valueOf((String)value));
                }
                if (caps.getCapability(HOST) != null && (value = (String)caps.getCapability(HOST)) != null) {
                    builder.withHost((String)value);
                }
                if (caps.getCapability(EXTRACT_PATH) != null && (value = (String)caps.getCapability(EXTRACT_PATH)) != null) {
                    builder.withExtractPath(new File((String)value));
                }
                if (caps.getCapability(SILENT) != null && (value = (Boolean)caps.getCapability(SILENT)) != null) {
                    builder.withSilent((Boolean)value);
                }
            }
            return builder.build();
        }
        catch (IllegalStateException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private void prepareProxy(Capabilities caps) {
        if (caps == null || caps.getCapability("proxy") == null || this.proxyManager == null) {
            return;
        }
        this.proxyManager.backupRegistrySettings();
        this.proxyManager.changeRegistrySettings(caps);
        Thread cleanupThread = new Thread(){

            @Override
            public void run() {
                InternetExplorerDriver.this.proxyManager.restoreRegistrySettings(true);
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupThread);
    }
}

