/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.Log;
import org.openqa.selenium.devtools.target.Target;
import org.openqa.selenium.devtools.target.model.SessionId;
import org.openqa.selenium.devtools.target.model.TargetId;
import org.openqa.selenium.devtools.target.model.TargetInfo;

public class DevTools
implements Closeable {
    private final Duration timeout = Duration.ofSeconds(10L);
    private final Connection connection;
    private SessionId cdpSession = null;

    public DevTools(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public <X> X send(Command<X> command) {
        Objects.requireNonNull(command, "Command to send must be set.");
        return this.connection.sendAndWait(this.cdpSession, command, this.timeout);
    }

    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        Objects.requireNonNull(event, "Event to listen for must be set.");
        Objects.requireNonNull(handler, "Handler to call must be set.");
        this.connection.addListener(event, handler);
    }

    public void createSession() {
        List<TargetInfo> infos = this.connection.sendAndWait(this.cdpSession, Target.getTargets(), this.timeout);
        TargetId targetId = infos.stream().filter(info -> "page".equals(info.getType())).map(TargetInfo::getTargetId).findAny().orElseThrow(() -> new DevToolsException("Unable to find target id of a page"));
        this.cdpSession = this.connection.sendAndWait(this.cdpSession, Target.attachToTarget(targetId, Optional.empty()), this.timeout);
        try {
            CompletableFuture.allOf(this.connection.send(this.cdpSession, Target.setAutoAttach(true, false, Optional.empty())), this.connection.send(this.cdpSession, Log.clear())).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread has been interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new DevToolsException(cause);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
    }
}

