/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.network.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.network.model.ConnectionType;
import org.openqa.selenium.devtools.network.model.Cookies;
import org.openqa.selenium.devtools.network.model.DataReceived;
import org.openqa.selenium.devtools.network.model.ErrorReason;
import org.openqa.selenium.devtools.network.model.EventSourceMessageReceived;
import org.openqa.selenium.devtools.network.model.InterceptionId;
import org.openqa.selenium.devtools.network.model.LoadingFailed;
import org.openqa.selenium.devtools.network.model.LoadingFinished;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.devtools.network.model.RequestIntercepted;
import org.openqa.selenium.devtools.network.model.RequestPattern;
import org.openqa.selenium.devtools.network.model.RequestWillBeSent;
import org.openqa.selenium.devtools.network.model.ResourceChangedPriority;
import org.openqa.selenium.devtools.network.model.ResponseBody;
import org.openqa.selenium.devtools.network.model.ResponseReceived;
import org.openqa.selenium.devtools.network.model.SearchMatch;
import org.openqa.selenium.devtools.network.model.SignedExchangeReceived;
import org.openqa.selenium.devtools.network.model.WebSocketClosed;
import org.openqa.selenium.devtools.network.model.WebSocketCreated;
import org.openqa.selenium.devtools.network.model.WebSocketFrame;
import org.openqa.selenium.devtools.network.model.WebSocketFrameError;

public class Network {
    private static final String DOMAIN_NAME = "Network";

    public static Command<Void> clearBrowserCache() {
        return new Command<Void>("Network.clearBrowserCache", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Void> clearBrowserCookies() {
        return new Command<Void>("Network.clearBrowserCookies", (Map<String, Object>)ImmutableMap.of());
    }

    @Beta
    public static Command<Void> continueInterceptedRequest(InterceptionId interceptionId, Optional<ErrorReason> errorReason, Optional<String> rawResponse, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<Map<String, String>> headers, Optional<AuthChallengeResponse> authChallengeResponse) {
        Objects.requireNonNull(interceptionId, "interceptionId must be set.");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"interceptionId", (Object)interceptionId.toString());
        errorReason.ifPresent(reason -> params.put((Object)"errorReason", (Object)((ErrorReason)((Object)((Object)errorReason.get()))).name()));
        rawResponse.ifPresent(string -> params.put((Object)"rawResponse", (Object)rawResponse.toString()));
        url.ifPresent(string -> params.put((Object)"url", (Object)url.toString()));
        method.ifPresent(string -> params.put((Object)"method", (Object)method.toString()));
        postData.ifPresent(string -> params.put((Object)"postData", (Object)postData.toString()));
        headers.ifPresent(map -> params.put((Object)"headers", (Object)headers));
        authChallengeResponse.ifPresent(response -> params.put((Object)"authChallengeResponse", (Object)authChallengeResponse));
        return new Command<Void>("Network.continueInterceptedRequest", (Map<String, Object>)params.build());
    }

    public static Command<Void> deleteCookies(String name, Optional<String> url, Optional<String> domain, Optional<String> path) {
        Objects.requireNonNull(name, "name must be set.");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"name", (Object)name);
        url.ifPresent(string -> params.put((Object)"url", (Object)url.toString()));
        domain.ifPresent(string -> params.put((Object)"domain", (Object)domain.toString()));
        path.ifPresent(string -> params.put((Object)"path", (Object)path.toString()));
        return new Command<Void>("Network.deleteCookies", (Map<String, Object>)params.build());
    }

    public static Command<Void> disable() {
        return new Command<Void>("Network.disable", (Map<String, Object>)ImmutableMap.of());
    }

    public static Command<Void> emulateNetworkConditions(boolean offline, double latency, double downloadThroughput, double uploadThroughput, Optional<ConnectionType> connectionType) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"offline", (Object)offline);
        params.put((Object)"latency", (Object)latency);
        params.put((Object)"downloadThroughput", (Object)downloadThroughput);
        params.put((Object)"uploadThroughput", (Object)uploadThroughput);
        connectionType.ifPresent(ConnectionType2 -> params.put((Object)"connectionType", (Object)((ConnectionType)((Object)((Object)connectionType.get()))).name()));
        return new Command<Void>("Network.emulateNetworkConditions", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable(Optional<Integer> maxTotalBufferSize, Optional<Integer> maxResourceBufferSize, Optional<Integer> maxPostDataSize) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        maxTotalBufferSize.ifPresent(integer -> params.put((Object)"maxTotalBufferSize", integer));
        maxResourceBufferSize.ifPresent(integer -> params.put((Object)"maxResourceBufferSize", integer));
        maxPostDataSize.ifPresent(integer -> params.put((Object)"maxPostDataSize", integer));
        return new Command<Void>("Network.enable", (Map<String, Object>)params.build());
    }

    public static Command<Cookies> getAllCookies() {
        return new Command<Cookies>("Network.getAllCookies", (Map<String, Object>)ImmutableMap.of(), ConverterFunctions.map("cookies", Cookies.class));
    }

    @Beta
    public static Command<List<String>> getCertificate(String origin) {
        Objects.requireNonNull(origin, "origin must be set.");
        return new Command<List<String>>("Network.getCertificate", (Map<String, Object>)ImmutableMap.of((Object)"origin", (Object)origin), ConverterFunctions.map("tableNames", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<Cookies> getCookies(Optional<List<String>> urls) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        urls.ifPresent(list -> params.put((Object)"urls", (Object)urls));
        return new Command<Cookies>("Network.getCookies", (Map<String, Object>)params.build(), ConverterFunctions.map("cookies", Cookies.class));
    }

    public static Command<ResponseBody> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId must be set.");
        return new Command<ResponseBody>("Network.getResponseBody", (Map<String, Object>)ImmutableMap.of((Object)"requestId", (Object)requestId.toString()), ConverterFunctions.map("body", ResponseBody.class));
    }

    public static Command<String> getRequestPostData(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId must be set.");
        return new Command<String>("Network.getRequestPostData", (Map<String, Object>)ImmutableMap.of((Object)"requestId", (Object)requestId.toString()), ConverterFunctions.map("postData", String.class));
    }

    @Beta
    public static Command<ResponseBody> getResponseBodyForInterception(InterceptionId interceptionId) {
        Objects.requireNonNull(interceptionId.toString(), "interceptionId must be set.");
        return new Command<ResponseBody>("Network.getResponseBodyForInterception", (Map<String, Object>)ImmutableMap.of((Object)"interceptionId", (Object)interceptionId), ConverterFunctions.map("body", ResponseBody.class));
    }

    @Beta
    public static Command<String> takeResponseBodyForInterceptionAsStream(InterceptionId interceptionId) {
        Objects.requireNonNull(interceptionId, "interceptionId must be set.");
        return new Command<String>("Network.takeResponseBodyForInterceptionAsStream", (Map<String, Object>)ImmutableMap.of((Object)"interceptionId", (Object)interceptionId), ConverterFunctions.map("stream", String.class));
    }

    public static Command<Void> replayXHR(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId must be set.");
        return new Command<Void>("Network.replayXHR", (Map<String, Object>)ImmutableMap.of((Object)"requestId", (Object)requestId.toString()));
    }

    @Beta
    public static Command<List<SearchMatch>> searchInResponseBody(RequestId requestId, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(requestId, "requestId must be set.");
        Objects.requireNonNull(query, "query must be set.");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId.toString());
        params.put((Object)"query", (Object)query);
        caseSensitive.ifPresent(bool -> params.put((Object)"caseSensitive", (Object)caseSensitive));
        isRegex.ifPresent(bool -> params.put((Object)"isRegex", (Object)isRegex));
        return new Command<List<SearchMatch>>("Network.searchInResponseBody", (Map<String, Object>)params.build(), ConverterFunctions.map("result", new TypeToken<List<SearchMatch>>(){}.getType()));
    }

    @Beta
    public static Command<Void> setBlockedURLs(List<String> urls) {
        Objects.requireNonNull(urls, "urls must be set.");
        return new Command<Void>("Network.setBlockedURLs", (Map<String, Object>)ImmutableMap.of((Object)"urls", urls));
    }

    @Beta
    public static Command<Void> setBypassServiceWorker(boolean bypass) {
        return new Command<Void>("Network.setBypassServiceWorker", (Map<String, Object>)ImmutableMap.of((Object)"bypass", (Object)bypass));
    }

    public static Command<Void> setCacheDisabled(boolean cacheDisabled) {
        return new Command<Void>("Network.setCacheDisabled", (Map<String, Object>)ImmutableMap.of((Object)"cacheDisabled", (Object)cacheDisabled));
    }

    private static Command<Boolean> setCookie(org.openqa.selenium.devtools.network.model.Cookie cookie, Optional<String> url) {
        Objects.requireNonNull(cookie.getName(), "cookieName must be set.");
        Objects.requireNonNull(cookie.getValue(), "cookieValue must be set.");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"name", (Object)cookie.getName());
        params.put((Object)"value", (Object)cookie.getValue());
        url.ifPresent(string -> params.put((Object)"url", (Object)url.toString()));
        if (cookie.getDomain() != null) {
            params.put((Object)"domain", (Object)cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            params.put((Object)"path", (Object)cookie.getPath());
        }
        params.put((Object)"secure", (Object)cookie.isSecure());
        params.put((Object)"httpOnly", (Object)cookie.isHttpOnly());
        if (cookie.getExpires() != 0L) {
            params.put((Object)"expires", (Object)cookie.getExpires());
        }
        return new Command<Boolean>("Network.setCookie", (Map<String, Object>)params.build(), ConverterFunctions.map("success", Boolean.class));
    }

    public static Command<Boolean> setCookie(Cookie cookie, Optional<String> url) {
        return Network.setCookie(org.openqa.selenium.devtools.network.model.Cookie.fromSeleniumCookie(cookie), url);
    }

    @Beta
    public static Command<Void> setDataSizeLimitsForTest(int maxTotalSize, int maxResourceSize) {
        return new Command<Void>("Network.setDataSizeLimitsForTest", (Map<String, Object>)ImmutableMap.of((Object)"maxTotalSize", (Object)maxTotalSize, (Object)"maxResourceSize", (Object)maxResourceSize));
    }

    public static Command<Void> setExtraHTTPHeaders(Map<String, String> headers) {
        Objects.requireNonNull(headers, "headers must be set.");
        return new Command<Void>("Network.setExtraHTTPHeaders", (Map<String, Object>)ImmutableMap.of((Object)"headers", headers));
    }

    @Beta
    public static Command<Void> setRequestInterception(List<RequestPattern> patterns) {
        Objects.requireNonNull(patterns, "patterns must be set.");
        return new Command<Void>("Network.setRequestInterception", (Map<String, Object>)ImmutableMap.of((Object)"patterns", patterns));
    }

    public static Command<Void> setUserAgentOverride(String userAgent, Optional<String> acceptLanguage, Optional<String> platform) {
        Objects.requireNonNull(userAgent, "userAgent must be set.");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"userAgent", (Object)userAgent);
        acceptLanguage.ifPresent(string -> params.put((Object)"acceptLanguage", (Object)acceptLanguage.toString()));
        platform.ifPresent(string -> params.put((Object)"platform", (Object)platform.toString()));
        return new Command<Void>("Network.setUserAgentOverride", (Map<String, Object>)params.build());
    }

    public static Event<DataReceived> dataReceived() {
        return new Event<DataReceived>("Network.dataReceived", ConverterFunctions.map("requestId", DataReceived.class));
    }

    public static Event<EventSourceMessageReceived> eventSourceMessageReceived() {
        return new Event<EventSourceMessageReceived>("Network.eventSourceMessageReceived", ConverterFunctions.map("requestId", EventSourceMessageReceived.class));
    }

    public static Event<LoadingFailed> loadingFailed() {
        return new Event<LoadingFailed>("Network.loadingFailed", ConverterFunctions.map("requestId", LoadingFailed.class));
    }

    public static Event<LoadingFinished> loadingFinished() {
        return new Event<LoadingFinished>("Network.loadingFinished", ConverterFunctions.map("requestId", LoadingFinished.class));
    }

    public static Event<RequestId> requestServedFromCache() {
        return new Event<RequestId>("Network.requestServedFromCache", ConverterFunctions.map("requestId", RequestId.class));
    }

    @Beta
    public static Event<ResourceChangedPriority> resourceChangedPriority() {
        return new Event<ResourceChangedPriority>("Network.resourceChangedPriority", ConverterFunctions.map("requestId", ResourceChangedPriority.class));
    }

    @Beta
    public static Event<SignedExchangeReceived> signedExchangeReceived() {
        return new Event<SignedExchangeReceived>("Network.signedExchangeReceived", ConverterFunctions.map("requestId", SignedExchangeReceived.class));
    }

    public static Event<RequestWillBeSent> requestWillBeSent() {
        return new Event<RequestWillBeSent>("Network.requestWillBeSent", ConverterFunctions.map("requestId", RequestWillBeSent.class));
    }

    @Beta
    public static Event<RequestIntercepted> requestIntercepted() {
        return new Event<RequestIntercepted>("Network.requestIntercepted", ConverterFunctions.map("interceptionId", RequestIntercepted.class));
    }

    public static Event<ResponseReceived> responseReceived() {
        return new Event<ResponseReceived>("Network.responseReceived", ConverterFunctions.map("requestId", ResponseReceived.class));
    }

    public static Event<WebSocketFrameError> webSocketFrameError() {
        return new Event<WebSocketFrameError>("Network.webSocketFrameError", ConverterFunctions.map("requestId", WebSocketFrameError.class));
    }

    public static Event<WebSocketCreated> webSocketCreated() {
        return new Event<WebSocketCreated>("Network.webSocketCreated", ConverterFunctions.map("requestId", WebSocketCreated.class));
    }

    public static Event<WebSocketClosed> webSocketClosed() {
        return new Event<WebSocketClosed>("Network.webSocketClosed", ConverterFunctions.map("requestId", WebSocketClosed.class));
    }

    public static Event<WebSocketFrame> webSocketFrameReceived() {
        return new Event<WebSocketFrame>("Network.webSocketFrameReceived", ConverterFunctions.map("requestId", WebSocketFrame.class));
    }

    public static Event<WebSocketFrame> webSocketFrameSent() {
        return new Event<WebSocketFrame>("Network.webSocketFrameSent", ConverterFunctions.map("requestId", WebSocketFrame.class));
    }
}

