/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.json.JsonInput;

public class EventSourceMessageReceived {
    private final String requestId;
    private final MonotonicTime timestamp;
    private final String eventName;
    private final String eventId;
    private final String data;

    private EventSourceMessageReceived(String requestId, MonotonicTime timestamp, String eventName, String eventId, String data) {
        this.requestId = requestId;
        this.timestamp = timestamp;
        this.eventName = eventName;
        this.eventId = eventId;
        this.data = data;
    }

    private static EventSourceMessageReceived fromJson(JsonInput input) {
        String requestId = input.nextString();
        MonotonicTime timestamp = null;
        String eventName = null;
        String eventId = null;
        String data = null;
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block12;
                }
                case "eventName": {
                    eventName = input.nextString();
                    continue block12;
                }
                case "eventId": {
                    eventId = input.nextString();
                    continue block12;
                }
                case "data": {
                    data = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        return new EventSourceMessageReceived(requestId, timestamp, eventName, eventId, data);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getData() {
        return this.data;
    }

    public String toString() {
        return "EventSourceMessageReceived{requestId='" + this.requestId + '\'' + ", timestamp=" + this.timestamp.getTimeStamp().toString() + ", eventName='" + this.eventName + '\'' + ", eventId='" + this.eventId + '\'' + ", data='" + this.data + '\'' + '}';
    }
}

