/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.BlockedReason;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.json.JsonInput;

public class LoadingFailed {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final ResourceType type;
    private final String errorText;
    private final Boolean canceled;
    private final BlockedReason blockedReason;

    private LoadingFailed(RequestId requestId, MonotonicTime timestamp, ResourceType resourceType, String errorText, Boolean canceled, BlockedReason blockedReason) {
        this.requestId = Objects.requireNonNull(requestId, "'requestId' is required for LoadingFailed");
        this.timestamp = Objects.requireNonNull(timestamp, "'timestamp' is required for LoadingFailed");
        this.type = Objects.requireNonNull(resourceType, "'resourceType' is required for LoadingFailed");
        this.errorText = Objects.requireNonNull(errorText, "'errorText' is required for LoadingFailed");
        this.canceled = canceled;
        this.blockedReason = blockedReason;
    }

    private static LoadingFailed fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        MonotonicTime timestamp = null;
        ResourceType type = null;
        String errorText = null;
        Boolean canceled = null;
        BlockedReason blockedReason = null;
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block14;
                }
                case "type": {
                    type = ResourceType.valueOf(input.nextString());
                    continue block14;
                }
                case "errorText": {
                    errorText = input.nextString();
                    continue block14;
                }
                case "canceled": {
                    canceled = input.nextBoolean();
                    continue block14;
                }
                case "blockedReason": {
                    blockedReason = BlockedReason.fromString(input.nextString());
                    continue block14;
                }
            }
            input.skipValue();
        }
        return new LoadingFailed(requestId, timestamp, type, errorText, canceled, blockedReason);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public ResourceType getResourceType() {
        return this.type;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public Boolean getCanceled() {
        return this.canceled;
    }

    public BlockedReason getBlockedReason() {
        return this.blockedReason;
    }

    public String toString() {
        return "LoadingFailed{requestId=" + this.requestId + ", timestamp=" + this.timestamp.getTimeStamp().toString() + ", resourceType=" + (Object)((Object)this.type) + ", errorText='" + this.errorText + '\'' + ", canceled=" + this.canceled + ", blockedReason=" + (Object)((Object)this.blockedReason) + '}';
    }
}

