/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.MixedContentType;
import org.openqa.selenium.devtools.network.model.RequestReferrerPolicy;
import org.openqa.selenium.devtools.network.model.ResourcePriority;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public class Request {
    private String url;
    private String urlFragment;
    private String method;
    private Map<String, Object> headers;
    private String postData;
    private Boolean hasPostData;
    private MixedContentType mixedContentType;
    private ResourcePriority initialPriority;
    private RequestReferrerPolicy referrerPolicy;
    private Boolean isLinkPreload;

    public Request() {
    }

    public Request(String url, String urlFragment, String method, Map<String, Object> headers, String postData, Boolean hasPostData, MixedContentType mixedContentType, ResourcePriority initialPriority, RequestReferrerPolicy referrerPolicy, Boolean isLinkPreload) {
        this.url = Objects.requireNonNull(url, "'url' is require");
        this.urlFragment = urlFragment;
        this.method = method;
        this.headers = headers;
        this.postData = postData;
        this.hasPostData = hasPostData;
        this.mixedContentType = mixedContentType;
        this.initialPriority = initialPriority;
        this.referrerPolicy = referrerPolicy;
        this.isLinkPreload = isLinkPreload;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlFragment() {
        return this.urlFragment;
    }

    public void setUrlFragment(String urlFragment) {
        this.urlFragment = urlFragment;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public String getPostData() {
        return this.postData;
    }

    public void setPostData(String postData) {
        this.postData = postData;
    }

    public Boolean getHasPostData() {
        return this.hasPostData;
    }

    public void setHasPostData(Boolean hasPostData) {
        this.hasPostData = hasPostData;
    }

    public MixedContentType getMixedContentType() {
        return this.mixedContentType;
    }

    public void setMixedContentType(MixedContentType mixedContentType) {
        this.mixedContentType = mixedContentType;
    }

    public ResourcePriority getInitialPriority() {
        return this.initialPriority;
    }

    public void setInitialPriority(ResourcePriority initialPriority) {
        this.initialPriority = initialPriority;
    }

    public RequestReferrerPolicy getReferrerPolicy() {
        return this.referrerPolicy;
    }

    public void setReferrerPolicy(RequestReferrerPolicy referrerPolicy) {
        this.referrerPolicy = referrerPolicy;
    }

    public Boolean getIsLinkPreload() {
        return this.isLinkPreload;
    }

    public void setIsLinkPreload(Boolean isLinkPreload) {
        this.isLinkPreload = isLinkPreload;
    }

    private static Request fromJson(JsonInput input) {
        input.beginObject();
        String url = null;
        String method = null;
        String urlFragment = null;
        Map headers = null;
        String postData = null;
        Boolean hasPostData = null;
        MixedContentType mixedContentType = null;
        ResourcePriority initialPriority = null;
        RequestReferrerPolicy referrerPolicy = null;
        Boolean isLinkPreload = null;
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block22;
                }
                case "method": {
                    method = input.nextString();
                    continue block22;
                }
                case "urlFragment": {
                    urlFragment = input.nextString();
                    continue block22;
                }
                case "headers": {
                    headers = (Map)input.read(Json.MAP_TYPE);
                    continue block22;
                }
                case "postData": {
                    postData = input.nextString();
                    continue block22;
                }
                case "mixedContentType": {
                    mixedContentType = MixedContentType.fromString(input.nextString());
                    continue block22;
                }
                case "initialPriority": {
                    initialPriority = ResourcePriority.valueOf(input.nextString());
                    continue block22;
                }
                case "referrerPolicy": {
                    referrerPolicy = RequestReferrerPolicy.fromString(input.nextString());
                    continue block22;
                }
                case "isLinkPreload": {
                    isLinkPreload = input.nextBoolean();
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Request(url, urlFragment, method, headers, postData, hasPostData, mixedContentType, initialPriority, referrerPolicy, isLinkPreload);
    }
}

