/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.AuthChallenge;
import org.openqa.selenium.devtools.network.model.ErrorReason;
import org.openqa.selenium.devtools.network.model.InterceptionId;
import org.openqa.selenium.devtools.network.model.Request;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;

public class RequestIntercepted {
    private final InterceptionId interceptionId;
    private final Request request;
    private final String frameId;
    private final ResourceType resourceType;
    private final boolean isNavigationRequest;
    private final Boolean isDownload;
    private final String redirectUrl;
    private final AuthChallenge authChallenge;
    private final ErrorReason responseErrorReason;
    private final Number responseStatusCode;
    private final Object responseHeaders;
    private final String requestId;

    private RequestIntercepted(InterceptionId interceptionId, Request request, String frameId, ResourceType resourceType, boolean isNavigationRequest, Boolean isDownload, String redirectUrl, AuthChallenge authChallenge, ErrorReason responseErrorReason, Number responseStatusCode, Object responseHeaders, String requestId) {
        this.interceptionId = Objects.requireNonNull(interceptionId, "'interceptionId' is required for RequestIntercepted");
        this.request = Objects.requireNonNull(request, "'request' is required for RequestIntercepted");
        this.frameId = Objects.requireNonNull(frameId, "'frameId' is required for RequestIntercepted");
        this.resourceType = Objects.requireNonNull(resourceType, "'resourceType' is required for RequestIntercepted");
        this.isNavigationRequest = isNavigationRequest;
        this.isDownload = isDownload;
        this.redirectUrl = redirectUrl;
        this.authChallenge = authChallenge;
        this.responseErrorReason = responseErrorReason;
        this.responseStatusCode = responseStatusCode;
        this.responseHeaders = responseHeaders;
        this.requestId = requestId;
    }

    private static RequestIntercepted fromJson(JsonInput input) {
        InterceptionId interceptionId = new InterceptionId(input.nextString());
        Request request = null;
        String frameId = null;
        ResourceType resourceType = null;
        Boolean isNavigationRequest = null;
        Boolean isDownload = null;
        String redirectUrl = null;
        AuthChallenge authChallenge = null;
        ErrorReason responseErrorReason = null;
        Number responseStatusCode = null;
        Object responseHeaders = null;
        String requestId = null;
        block26: while (input.hasNext()) {
            switch (input.nextName()) {
                case "request": {
                    request = (Request)input.read((Type)((Object)Request.class));
                    continue block26;
                }
                case "frameId": {
                    frameId = input.nextString();
                    continue block26;
                }
                case "resourceType": {
                    resourceType = ResourceType.valueOf(input.nextString());
                    continue block26;
                }
                case "isNavigationRequest": {
                    isNavigationRequest = input.nextBoolean();
                    continue block26;
                }
                case "isDownload": {
                    isDownload = input.nextBoolean();
                    continue block26;
                }
                case "redirectUrl": {
                    redirectUrl = input.nextString();
                    continue block26;
                }
                case "authChallenge": {
                    authChallenge = (AuthChallenge)input.read((Type)((Object)AuthChallenge.class));
                    continue block26;
                }
                case "responseErrorReason": {
                    responseErrorReason = ErrorReason.valueOf(input.nextString());
                    continue block26;
                }
                case "responseStatusCode": {
                    responseStatusCode = input.nextNumber();
                    continue block26;
                }
                case "responseHeaders": {
                    responseHeaders = input.read(Json.MAP_TYPE);
                    continue block26;
                }
                case "requestId": {
                    requestId = input.nextString();
                    continue block26;
                }
            }
            input.skipValue();
        }
        return new RequestIntercepted(interceptionId, request, frameId, resourceType, isNavigationRequest, isDownload, redirectUrl, authChallenge, responseErrorReason, responseStatusCode, responseHeaders, requestId);
    }

    public InterceptionId getInterceptionId() {
        return this.interceptionId;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean isNavigationRequest() {
        return this.isNavigationRequest;
    }

    public Boolean getDownload() {
        return this.isDownload;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public AuthChallenge getAuthChallenge() {
        return this.authChallenge;
    }

    public ErrorReason getResponseErrorReason() {
        return this.responseErrorReason;
    }

    public Number getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public Object getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getRequestId() {
        return this.requestId;
    }
}

