/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler.model;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.profiler.model.FunctionCoverage;
import org.openqa.selenium.json.JsonInput;

public class ScriptCoverage {
    private final String scriptId;
    private final String url;
    private final List<FunctionCoverage> functions;

    public ScriptCoverage(String scriptId, String url, List<FunctionCoverage> functions) {
        this.validateFunctionCovarage(functions);
        Objects.requireNonNull(url, "url is require");
        Objects.requireNonNull(scriptId, "scriptId is require");
        this.scriptId = scriptId;
        this.url = url;
        this.functions = functions;
    }

    private static ScriptCoverage parse(JsonInput input) {
        String scriptId = null;
        String url = null;
        ArrayList functionCoverages = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptId": {
                    scriptId = input.nextString();
                    continue block10;
                }
                case "url": {
                    url = input.nextString();
                    continue block10;
                }
                case "functions": {
                    functionCoverages = new ArrayList();
                    input.beginArray();
                    while (input.hasNext()) {
                        functionCoverages.add(input.read((Type)((Object)FunctionCoverage.class)));
                    }
                    input.endArray();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScriptCoverage(scriptId, url, functionCoverages);
    }

    private static List<ScriptCoverage> fromJson(JsonInput input) {
        ArrayList<ScriptCoverage> coverages = new ArrayList<ScriptCoverage>();
        while (input.hasNext()) {
            coverages.add(ScriptCoverage.parse(input));
        }
        return coverages;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    private void validateFunctionCovarage(List<FunctionCoverage> functionCoverages) {
        Objects.requireNonNull(functionCoverages, "functions is require");
        if (functionCoverages.isEmpty()) {
            throw new DevToolsException("functions are required");
        }
    }

    public String getUrl() {
        return this.url;
    }

    public List<FunctionCoverage> getFunctions() {
        return this.functions;
    }
}

