/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.target.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.target.model.SessionId;
import org.openqa.selenium.devtools.target.model.TargetId;
import org.openqa.selenium.json.JsonInput;

public class AttachToTarget {
    private final SessionId sessionId;
    private final TargetId targetId;
    private final boolean waitForDebugger;

    public AttachToTarget(SessionId sessionId, TargetId targetId, Boolean waitForDebugger) {
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId is required");
        this.targetId = Objects.requireNonNull(targetId, "targetId is required");
        this.waitForDebugger = Objects.requireNonNull(waitForDebugger, "waitForDebugger is require");
    }

    private static AttachToTarget fromJson(JsonInput input) {
        SessionId sessionId = null;
        TargetId targetId = null;
        Boolean waitForDebugger = null;
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "sessionId": {
                    sessionId = (SessionId)input.read((Type)((Object)SessionId.class));
                    continue block10;
                }
                case "targetId": {
                    targetId = (TargetId)input.read((Type)((Object)TargetId.class));
                    continue block10;
                }
                case "waitForDebugger": {
                    waitForDebugger = input.nextBoolean();
                    continue block10;
                }
            }
            input.skipValue();
        }
        return new AttachToTarget(sessionId, targetId, waitForDebugger);
    }
}

