/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openqa.selenium.Cookie;

public class ReturnedCookie
extends Cookie {
    private final boolean isSecure;

    public ReturnedCookie(String name, String value, String domain, String path, Date expiry, boolean isSecure) {
        super(name, value, domain, path, expiry);
        this.isSecure = isSecure;
        this.validate();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    protected void validate() {
        super.validate();
        String domain = this.getDomain();
        if (domain != null && !"".equals(domain)) {
            try {
                String domainToUse = domain.startsWith("http") ? domain : "http://" + domain;
                URL url = new URL(domainToUse);
                InetAddress.getByName(url.getHost());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(String.format("URL not valid: %s", domain));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Domain does not exist: %s", domain));
            }
        }
    }

    public String toString() {
        return this.getName() + "=" + this.getValue() + ("".equals(this.getPath()) ? "" : ";path=" + this.getPath()) + (this.getExpiry() == null ? "" : ";expires=" + new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z").format(this.getExpiry())) + (this.isSecure ? ";secure;" : "");
    }
}

