/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class MilvusFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    protected void doExpression(Filter.Expression exp, StringBuilder context) {
        this.convertOperand(exp.left(), context);
        context.append(this.getOperationSymbol(exp));
        this.convertOperand(exp.right(), context);
    }

    private String getOperationSymbol(Filter.Expression exp) {
        switch (exp.type()) {
            case AND: {
                return " && ";
            }
            case OR: {
                return " || ";
            }
            case EQ: {
                return " == ";
            }
            case NE: {
                return " != ";
            }
            case LT: {
                return " < ";
            }
            case LTE: {
                return " <= ";
            }
            case GT: {
                return " > ";
            }
            case GTE: {
                return " >= ";
            }
            case IN: {
                return " in ";
            }
            case NIN: {
                return " nin ";
            }
        }
        throw new RuntimeException("Not supported expression type:" + exp.type());
    }

    protected void doGroup(Filter.Group group, StringBuilder context) {
        this.convertOperand((Filter.Operand)new Filter.Expression(Filter.ExpressionType.AND, (Filter.Operand)group.content(), (Filter.Operand)group.content()), context);
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        String identifier = this.hasOuterQuotes(key.key()) ? this.removeOuterQuotes(key.key()) : key.key();
        context.append("metadata[\"" + identifier + "\"]");
    }
}

