/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingClient;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class OpenAiEmbeddingClient
extends AbstractEmbeddingClient {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiEmbeddingClient.class);
    private final OpenAiEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(10).retryOn(OpenAiApi.OpenAiApiException.class).exponentialBackoff(Duration.ofMillis(2000L), 5.0, Duration.ofMillis(180000L)).withListener(new RetryListener(){

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
            logger.warn("Retry error. Retry count:" + context.getRetryCount(), throwable);
        }
    }).build();
    private final OpenAiApi openAiApi;
    private final MetadataMode metadataMode;

    public OpenAiEmbeddingClient(OpenAiApi openAiApi) {
        this(openAiApi, MetadataMode.EMBED);
    }

    public OpenAiEmbeddingClient(OpenAiApi openAiApi, MetadataMode metadataMode) {
        this(openAiApi, metadataMode, OpenAiEmbeddingOptions.builder().withModel("text-embedding-ada-002").build());
    }

    public OpenAiEmbeddingClient(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions options) {
        Assert.notNull((Object)openAiApi, (String)"OpenAiService must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        this.openAiApi = openAiApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
    }

    public List<Double> embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        return (EmbeddingResponse)this.retryTemplate.execute(ctx -> {
            OpenAiApi.EmbeddingList apiEmbeddingResponse;
            OpenAiApi.EmbeddingRequest<Object> apiRequest;
            OpenAiApi.EmbeddingRequest<Object> embeddingRequest = apiRequest = this.defaultOptions != null ? new OpenAiApi.EmbeddingRequest(request.getInstructions(), this.defaultOptions.getModel(), this.defaultOptions.getEncodingFormat(), this.defaultOptions.getUser()) : new OpenAiApi.EmbeddingRequest<List>(request.getInstructions(), "text-embedding-ada-002");
            if (request.getOptions() != null && !EmbeddingOptions.EMPTY.equals(request.getOptions())) {
                apiRequest = (OpenAiApi.EmbeddingRequest<Object>)ModelOptionsUtils.merge((Object)request.getOptions(), apiRequest, OpenAiApi.EmbeddingRequest.class);
            }
            if ((apiEmbeddingResponse = (OpenAiApi.EmbeddingList)this.openAiApi.embeddings(apiRequest).getBody()) == null) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            EmbeddingResponseMetadata metadata = this.generateResponseMetadata(apiEmbeddingResponse.model(), apiEmbeddingResponse.usage());
            List<Embedding> embeddings = apiEmbeddingResponse.data().stream().map(e -> new Embedding(e.embedding(), e.index())).toList();
            return new EmbeddingResponse(embeddings, metadata);
        });
    }

    private EmbeddingResponseMetadata generateResponseMetadata(String model, OpenAiApi.Usage usage) {
        EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();
        metadata.put((Object)"model", (Object)model);
        metadata.put((Object)"prompt-tokens", (Object)usage.promptTokens());
        metadata.put((Object)"completion-tokens", (Object)usage.completionTokens());
        metadata.put((Object)"total-tokens", (Object)usage.totalTokens());
        return metadata;
    }
}

