/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class OpenAiImageApi {
    private static final String DEFAULT_BASE_URL = "https://api.openai.com";
    public static final String DEFAULT_IMAGE_MODEL = "dall-e-2";
    private final RestClient restClient;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public OpenAiImageApi(String openAiToken) {
        this(DEFAULT_BASE_URL, openAiToken, RestClient.builder());
    }

    public OpenAiImageApi(String baseUrl, String openAiToken, RestClient.Builder restClientBuilder) {
        Consumer<HttpHeaders> jsonContentHeaders = headers -> {
            headers.setBearerAuth(openAiToken);
            headers.setContentType(MediaType.APPLICATION_JSON);
        };
        ResponseErrorHandler responseErrorHandler = new ResponseErrorHandler(){

            public boolean hasError(ClientHttpResponse response) throws IOException {
                return response.getStatusCode().isError();
            }

            public void handleError(ClientHttpResponse response) throws IOException {
                if (response.getStatusCode().isError()) {
                    if (response.getStatusCode().is4xxClientError()) {
                        throw new OpenAiApi.OpenAiApiClientErrorException(String.format("%s - %s", response.getStatusCode().value(), OpenAiImageApi.this.objectMapper.readValue(response.getBody(), OpenAiApi.ResponseError.class)));
                    }
                    throw new OpenAiApi.OpenAiApiException(String.format("%s - %s", response.getStatusCode().value(), OpenAiImageApi.this.objectMapper.readValue(response.getBody(), OpenAiApi.ResponseError.class)));
                }
            }
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(jsonContentHeaders).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<OpenAiImageResponse> createImage(OpenAiImageRequest openAiImageRequest) {
        Assert.notNull((Object)openAiImageRequest, (String)"Image request cannot be null.");
        Assert.hasLength((String)openAiImageRequest.prompt(), (String)"Prompt cannot be empty.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("v1/images/generations", new Object[0])).body((Object)openAiImageRequest).retrieve().toEntity(OpenAiImageResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiImageRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="model") String model, @JsonProperty(value="n") Integer n, @JsonProperty(value="quality") String quality, @JsonProperty(value="response_format") String responseFormat, @JsonProperty(value="size") String size, @JsonProperty(value="style") String style, @JsonProperty(value="user") String user) {
        public OpenAiImageRequest(String prompt, String model) {
            this(prompt, model, null, null, null, null, null, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiImageResponse(@JsonProperty(value="created") Long created, @JsonProperty(value="data") List<Data> data) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Data(@JsonProperty(value="url") String url, @JsonProperty(value="b64_json") String b64Json, @JsonProperty(value="revised_prompt") String revisedPrompt) {
    }
}

