/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.metadata.support;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.metadata.OpenAiRateLimit;
import org.springframework.ai.openai.metadata.support.OpenAiApiResponseHeaders;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OpenAiResponseHeaderExtractor {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiResponseHeaderExtractor.class);

    public static RateLimit extractAiResponseHeaders(ResponseEntity<OpenAiApi.ChatCompletion> response) {
        Long requestsLimit = OpenAiResponseHeaderExtractor.getHeaderAsLong(response, OpenAiApiResponseHeaders.REQUESTS_LIMIT_HEADER.getName());
        Long requestsRemaining = OpenAiResponseHeaderExtractor.getHeaderAsLong(response, OpenAiApiResponseHeaders.REQUESTS_REMAINING_HEADER.getName());
        Long tokensLimit = OpenAiResponseHeaderExtractor.getHeaderAsLong(response, OpenAiApiResponseHeaders.TOKENS_LIMIT_HEADER.getName());
        Long tokensRemaining = OpenAiResponseHeaderExtractor.getHeaderAsLong(response, OpenAiApiResponseHeaders.TOKENS_REMAINING_HEADER.getName());
        Duration requestsReset = OpenAiResponseHeaderExtractor.getHeaderAsDuration(response, OpenAiApiResponseHeaders.REQUESTS_RESET_HEADER.getName());
        Duration tokensReset = OpenAiResponseHeaderExtractor.getHeaderAsDuration(response, OpenAiApiResponseHeaders.TOKENS_RESET_HEADER.getName());
        return new OpenAiRateLimit(requestsLimit, requestsRemaining, requestsReset, tokensLimit, tokensRemaining, tokensReset);
    }

    private static Duration getHeaderAsDuration(ResponseEntity<OpenAiApi.ChatCompletion> response, String headerName) {
        List values;
        HttpHeaders headers = response.getHeaders();
        if (headers.containsKey((Object)headerName) && !CollectionUtils.isEmpty((Collection)(values = headers.get((Object)headerName)))) {
            return DurationFormatter.TIME_UNIT.parse((String)values.get(0));
        }
        return null;
    }

    private static Long getHeaderAsLong(ResponseEntity<OpenAiApi.ChatCompletion> response, String headerName) {
        List values;
        HttpHeaders headers = response.getHeaders();
        if (headers.containsKey((Object)headerName) && !CollectionUtils.isEmpty((Collection)(values = headers.get((Object)headerName)))) {
            return OpenAiResponseHeaderExtractor.parseLong(headerName, (String)values.get(0));
        }
        return null;
    }

    private static Long parseLong(String headerName, String headerValue) {
        if (StringUtils.hasText((String)headerValue)) {
            try {
                return Long.parseLong(headerValue.trim());
            }
            catch (NumberFormatException e) {
                logger.warn("Value [{}] for HTTP header [{}] is not valid: {}", new Object[]{headerName, headerValue, e.getMessage()});
            }
        }
        return null;
    }

    static enum DurationFormatter {
        TIME_UNIT("\\d+[a-zA-Z]{1,2}");

        private final Pattern pattern;

        private DurationFormatter(String durationPattern) {
            this.pattern = Pattern.compile(durationPattern);
        }

        public Duration parse(String text) {
            Assert.hasText((String)text, (String)"Text [%s] to parse as a Duration must not be null or empty".formatted(text));
            Matcher matcher = this.pattern.matcher(text);
            Duration total = Duration.ZERO;
            while (matcher.find()) {
                String value = matcher.group();
                total = total.plus(Unit.parseUnit(value).toDuration(value));
            }
            return total;
        }

        static enum Unit {
            NANOSECONDS("ns", "nanoseconds", ChronoUnit.NANOS),
            MICROSECONDS("us", "microseconds", ChronoUnit.MICROS),
            MILLISECONDS("ms", "milliseconds", ChronoUnit.MILLIS),
            SECONDS("s", "seconds", ChronoUnit.SECONDS),
            MINUTES("m", "minutes", ChronoUnit.MINUTES),
            HOURS("h", "hours", ChronoUnit.HOURS),
            DAYS("d", "days", ChronoUnit.DAYS);

            private final String name;
            private final String symbol;
            private final ChronoUnit unit;

            private Unit(String symbol, String name, ChronoUnit unit) {
                this.symbol = symbol;
                this.name = name;
                this.unit = unit;
            }

            static Unit parseUnit(String value) {
                String symbol = Unit.parseSymbol(value);
                return Arrays.stream(Unit.values()).filter(unit -> unit.getSymbol().equalsIgnoreCase(symbol)).findFirst().orElseThrow(() -> new IllegalStateException("Value [%s] does not contain a valid time unit".formatted(value)));
            }

            private static String parse(String value, Predicate<Character> predicate) {
                Assert.hasText((String)value, (String)"Value [%s] must not be null or empty".formatted(value));
                StringBuilder builder = new StringBuilder();
                for (char character : value.toCharArray()) {
                    if (!predicate.test(Character.valueOf(character))) continue;
                    builder.append(character);
                }
                return builder.toString();
            }

            private static String parseSymbol(String value) {
                return Unit.parse(value, Character::isLetter);
            }

            private static Long parseTime(String value) {
                return Long.parseLong(Unit.parse(value, Character::isDigit));
            }

            public String getName() {
                return this.name;
            }

            public String getSymbol() {
                return this.symbol;
            }

            public ChronoUnit getUnit() {
                return this.unit;
            }

            public Duration toDuration(String value) {
                return Duration.of(Unit.parseTime(value), this.getUnit());
            }
        }
    }
}

