/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.openai.api.OpenAiAudioApi;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAiAudioSpeechOptions
implements ModelOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="input")
    private String input;
    @JsonProperty(value="voice")
    private OpenAiAudioApi.SpeechRequest.Voice voice;
    @JsonProperty(value="response_format")
    private OpenAiAudioApi.SpeechRequest.AudioResponseFormat responseFormat;
    @JsonProperty(value="speed")
    private Float speed;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public OpenAiAudioApi.SpeechRequest.Voice getVoice() {
        return this.voice;
    }

    public void setVoice(OpenAiAudioApi.SpeechRequest.Voice voice) {
        this.voice = voice;
    }

    public OpenAiAudioApi.SpeechRequest.AudioResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(OpenAiAudioApi.SpeechRequest.AudioResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Float getSpeed() {
        return this.speed;
    }

    public void setSpeed(Float speed) {
        this.speed = speed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        result = 31 * result + (this.voice == null ? 0 : this.voice.hashCode());
        result = 31 * result + (this.responseFormat == null ? 0 : this.responseFormat.hashCode());
        result = 31 * result + (this.speed == null ? 0 : this.speed.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenAiAudioSpeechOptions other = (OpenAiAudioSpeechOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.input == null ? other.input != null : !this.input.equals(other.input)) {
            return false;
        }
        if (this.voice == null ? other.voice != null : !this.voice.equals((Object)other.voice)) {
            return false;
        }
        if (this.responseFormat == null ? other.responseFormat != null : !this.responseFormat.equals((Object)other.responseFormat)) {
            return false;
        }
        if (this.speed == null) {
            return other.speed == null;
        }
        return this.speed.equals(other.speed);
    }

    public String toString() {
        return "OpenAiAudioSpeechOptions{model='" + this.model + "', input='" + this.input + "', voice='" + this.voice + "', responseFormat='" + this.responseFormat + "', speed=" + this.speed + "}";
    }

    public static class Builder {
        private final OpenAiAudioSpeechOptions options = new OpenAiAudioSpeechOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder input(String input) {
            this.options.input = input;
            return this;
        }

        public Builder voice(OpenAiAudioApi.SpeechRequest.Voice voice) {
            this.options.voice = voice;
            return this;
        }

        public Builder responseFormat(OpenAiAudioApi.SpeechRequest.AudioResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder speed(Float speed) {
            this.options.speed = speed;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String model) {
            this.options.model = model;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withInput(String input) {
            this.options.input = input;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withVoice(OpenAiAudioApi.SpeechRequest.Voice voice) {
            this.options.voice = voice;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withResponseFormat(OpenAiAudioApi.SpeechRequest.AudioResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withSpeed(Float speed) {
            this.options.speed = speed;
            return this;
        }

        public OpenAiAudioSpeechOptions build() {
            return this.options;
        }
    }
}

