/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.hanadb;

import io.micrometer.observation.ObservationRegistry;
import javax.sql.DataSource;
import org.springframework.ai.autoconfigure.vectorstore.hanadb.HanaCloudVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.HanaCloudVectorStore;
import org.springframework.ai.vectorstore.HanaCloudVectorStoreConfig;
import org.springframework.ai.vectorstore.HanaVectorEntity;
import org.springframework.ai.vectorstore.HanaVectorRepository;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={JpaRepositoriesAutoConfiguration.class})
@ConditionalOnClass(value={HanaCloudVectorStore.class, DataSource.class, HanaVectorEntity.class})
@EnableConfigurationProperties(value={HanaCloudVectorStoreProperties.class})
public class HanaCloudVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HanaCloudVectorStore vectorStore(HanaVectorRepository<? extends HanaVectorEntity> repository, EmbeddingModel embeddingModel, HanaCloudVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention) {
        return new HanaCloudVectorStore(repository, embeddingModel, HanaCloudVectorStoreConfig.builder().tableName(properties.getTableName()).topK(properties.getTopK()).build(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP), (VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null));
    }
}

