/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.weaviate;

import io.micrometer.observation.ObservationRegistry;
import io.weaviate.client.Config;
import io.weaviate.client.WeaviateAuthClient;
import io.weaviate.client.WeaviateClient;
import io.weaviate.client.v1.auth.exception.AuthException;
import org.springframework.ai.autoconfigure.vectorstore.weaviate.WeaviateConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.weaviate.WeaviateVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.WeaviateVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={EmbeddingModel.class, WeaviateVectorStore.class})
@EnableConfigurationProperties(value={WeaviateVectorStoreProperties.class})
public class WeaviateVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WeaviateConnectionDetails.class})
    public PropertiesWeaviateConnectionDetails weaviateConnectionDetails(WeaviateVectorStoreProperties properties) {
        return new PropertiesWeaviateConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public WeaviateClient weaviateClient(WeaviateVectorStoreProperties properties, WeaviateConnectionDetails connectionDetails) {
        try {
            return WeaviateAuthClient.apiKey((Config)new Config(properties.getScheme(), connectionDetails.getHost(), properties.getHeaders()), (String)properties.getApiKey());
        }
        catch (AuthException e) {
            throw new IllegalArgumentException("WeaviateClient could not be created.", e);
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public WeaviateVectorStore vectorStore(EmbeddingModel embeddingModel, WeaviateClient weaviateClient, WeaviateVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        WeaviateVectorStore.WeaviateVectorStoreConfig.Builder configBuilder = WeaviateVectorStore.WeaviateVectorStoreConfig.builder().withObjectClass(properties.getObjectClass()).withFilterableMetadataFields(properties.getFilterField().entrySet().stream().map(e -> new WeaviateVectorStore.WeaviateVectorStoreConfig.MetadataField((String)e.getKey(), (WeaviateVectorStore.WeaviateVectorStoreConfig.MetadataField.Type)e.getValue())).toList()).withConsistencyLevel(properties.getConsistencyLevel());
        return new WeaviateVectorStore(configBuilder.build(), embeddingModel, weaviateClient, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP), (VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null), batchingStrategy);
    }

    static class PropertiesWeaviateConnectionDetails
    implements WeaviateConnectionDetails {
        private final WeaviateVectorStoreProperties properties;

        PropertiesWeaviateConnectionDetails(WeaviateVectorStoreProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getHost() {
            return this.properties.getHost();
        }
    }
}

