/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public class SimpleRabbitListenerContainerFactory
extends AbstractRabbitListenerContainerFactory<SimpleMessageListenerContainer>
implements ApplicationContextAware,
ApplicationEventPublisherAware {
    private Executor taskExecutor;
    private PlatformTransactionManager transactionManager;
    private Integer txSize;
    private Integer concurrentConsumers;
    private Integer maxConcurrentConsumers;
    private Long startConsumerMinInterval;
    private Long stopConsumerMinInterval;
    private Integer consecutiveActiveTrigger;
    private Integer consecutiveIdleTrigger;
    private Integer prefetchCount;
    private Long receiveTimeout;
    private Boolean defaultRequeueRejected;
    private Advice[] adviceChain;
    private BackOff recoveryBackOff;
    private Boolean missingQueuesFatal;
    private Boolean mismatchedQueuesFatal;
    private ConsumerTagStrategy consumerTagStrategy;
    private Long idleEventInterval;
    private ApplicationEventPublisher applicationEventPublisher;
    private ApplicationContext applicationContext;

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTxSize(Integer txSize) {
        this.txSize = txSize;
    }

    public void setConcurrentConsumers(Integer concurrency) {
        this.concurrentConsumers = concurrency;
    }

    public void setMaxConcurrentConsumers(Integer maxConcurrency) {
        this.maxConcurrentConsumers = maxConcurrency;
    }

    public void setStartConsumerMinInterval(Long minStartInterval) {
        this.startConsumerMinInterval = minStartInterval;
    }

    public void setStopConsumerMinInterval(Long minStopInterval) {
        this.stopConsumerMinInterval = minStopInterval;
    }

    public void setConsecutiveActiveTrigger(Integer minConsecutiveActive) {
        this.consecutiveActiveTrigger = minConsecutiveActive;
    }

    public void setConsecutiveIdleTrigger(Integer minConsecutiveIdle) {
        this.consecutiveIdleTrigger = minConsecutiveIdle;
    }

    public void setPrefetchCount(Integer prefetch) {
        this.prefetchCount = prefetch;
    }

    public void setReceiveTimeout(Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setDefaultRequeueRejected(Boolean requeueRejected) {
        this.defaultRequeueRejected = requeueRejected;
    }

    public void setAdviceChain(Advice ... adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setRecoveryInterval(Long recoveryInterval) {
        this.recoveryBackOff = new FixedBackOff(recoveryInterval.longValue(), Long.MAX_VALUE);
    }

    public void setRecoveryBackOff(BackOff recoveryBackOff) {
        this.recoveryBackOff = recoveryBackOff;
    }

    public void setMissingQueuesFatal(Boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
    }

    public void setMismatchedQueuesFatal(Boolean mismatchedQueuesFatal) {
        this.mismatchedQueuesFatal = mismatchedQueuesFatal;
    }

    public void setConsumerTagStrategy(ConsumerTagStrategy consumerTagStrategy) {
        this.consumerTagStrategy = consumerTagStrategy;
    }

    public void setIdleEventInterval(Long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    protected SimpleMessageListenerContainer createContainerInstance() {
        return new SimpleMessageListenerContainer();
    }

    @Override
    protected void initializeContainer(SimpleMessageListenerContainer instance) {
        super.initializeContainer(instance);
        if (this.applicationContext != null) {
            instance.setApplicationContext(this.applicationContext);
        }
        if (this.taskExecutor != null) {
            instance.setTaskExecutor(this.taskExecutor);
        }
        if (this.transactionManager != null) {
            instance.setTransactionManager(this.transactionManager);
        }
        if (this.txSize != null) {
            instance.setTxSize(this.txSize);
        }
        if (this.concurrentConsumers != null) {
            instance.setConcurrentConsumers(this.concurrentConsumers);
        }
        if (this.maxConcurrentConsumers != null) {
            instance.setMaxConcurrentConsumers(this.maxConcurrentConsumers);
        }
        if (this.startConsumerMinInterval != null) {
            instance.setStartConsumerMinInterval(this.startConsumerMinInterval);
        }
        if (this.stopConsumerMinInterval != null) {
            instance.setStopConsumerMinInterval(this.stopConsumerMinInterval);
        }
        if (this.consecutiveActiveTrigger != null) {
            instance.setConsecutiveActiveTrigger(this.consecutiveActiveTrigger);
        }
        if (this.consecutiveIdleTrigger != null) {
            instance.setConsecutiveIdleTrigger(this.consecutiveIdleTrigger);
        }
        if (this.prefetchCount != null) {
            instance.setPrefetchCount(this.prefetchCount);
        }
        if (this.receiveTimeout != null) {
            instance.setReceiveTimeout(this.receiveTimeout);
        }
        if (this.defaultRequeueRejected != null) {
            instance.setDefaultRequeueRejected(this.defaultRequeueRejected);
        }
        if (this.adviceChain != null) {
            instance.setAdviceChain(this.adviceChain);
        }
        if (this.recoveryBackOff != null) {
            instance.setRecoveryBackOff(this.recoveryBackOff);
        }
        if (this.mismatchedQueuesFatal != null) {
            instance.setMismatchedQueuesFatal(this.mismatchedQueuesFatal);
        }
        if (this.missingQueuesFatal != null) {
            instance.setMissingQueuesFatal(this.missingQueuesFatal);
        }
        if (this.consumerTagStrategy != null) {
            instance.setConsumerTagStrategy(this.consumerTagStrategy);
        }
        if (this.idleEventInterval != null) {
            instance.setIdleEventInterval(this.idleEventInterval);
        }
        if (this.applicationEventPublisher != null) {
            instance.setApplicationEventPublisher(this.applicationEventPublisher);
        }
    }
}

