/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.builder;

import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.batch.item.database.support.ListPreparedStatementSetter;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.ArgumentTypePreparedStatementSetter;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcCursorItemReaderBuilder<T> {
    private DataSource dataSource;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    private boolean ignoreWarnings;
    private boolean verifyCursorPosition;
    private boolean driverSupportsAbsolute;
    private boolean useSharedExtendedConnection;
    private PreparedStatementSetter preparedStatementSetter;
    private String sql;
    private RowMapper<T> rowMapper;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public JdbcCursorItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> maxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> queryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> ignoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> verifyCursorPosition(boolean verifyCursorPosition) {
        this.verifyCursorPosition = verifyCursorPosition;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> driverSupportsAbsolute(boolean driverSupportsAbsolute) {
        this.driverSupportsAbsolute = driverSupportsAbsolute;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> useSharedExtendedConnection(boolean useSharedExtendedConnection) {
        this.useSharedExtendedConnection = useSharedExtendedConnection;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> preparedStatementSetter(PreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> queryArguments(Object ... args) {
        this.preparedStatementSetter = new ArgumentPreparedStatementSetter(args);
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> queryArguments(Object[] args, int[] types) {
        this.preparedStatementSetter = new ArgumentTypePreparedStatementSetter(args, types);
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> queryArguments(List<?> args) throws Exception {
        ListPreparedStatementSetter listPreparedStatementSetter = new ListPreparedStatementSetter(args);
        listPreparedStatementSetter.afterPropertiesSet();
        this.preparedStatementSetter = listPreparedStatementSetter;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> sql(String sql) {
        this.sql = sql;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> rowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
        return this;
    }

    public JdbcCursorItemReaderBuilder<T> beanRowMapper(Class<T> mappedClass) {
        this.rowMapper = new BeanPropertyRowMapper(mappedClass);
        return this;
    }

    public JdbcCursorItemReader<T> build() {
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        Assert.hasText((String)this.sql, (String)"A query is required");
        Assert.notNull((Object)this.dataSource, (String)"A datasource is required");
        Assert.notNull(this.rowMapper, (String)"A rowmapper is required");
        JdbcCursorItemReader<T> reader = new JdbcCursorItemReader<T>();
        if (StringUtils.hasText((String)this.name)) {
            reader.setName(this.name);
        }
        reader.setSaveState(this.saveState);
        reader.setPreparedStatementSetter(this.preparedStatementSetter);
        reader.setRowMapper(this.rowMapper);
        reader.setSql(this.sql);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setDataSource(this.dataSource);
        reader.setDriverSupportsAbsolute(this.driverSupportsAbsolute);
        reader.setFetchSize(this.fetchSize);
        reader.setIgnoreWarnings(this.ignoreWarnings);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setMaxRows(this.maxRows);
        reader.setQueryTimeout(this.queryTimeout);
        reader.setUseSharedExtendedConnection(this.useSharedExtendedConnection);
        reader.setVerifyCursorPosition(this.verifyCursorPosition);
        return reader;
    }
}

