/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.metrics.Autotime;
import org.springframework.boot.actuate.metrics.web.reactive.server.WebFluxTagsProvider;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483647)
public class MetricsWebFilter
implements WebFilter {
    private final MeterRegistry registry;
    private final WebFluxTagsProvider tagsProvider;
    private final String metricName;
    private final Autotime autotime;

    @Deprecated
    public MetricsWebFilter(MeterRegistry registry, WebFluxTagsProvider tagsProvider, String metricName, boolean autoTimeRequests) {
        this(registry, tagsProvider, metricName, new Autotime(autoTimeRequests, false, null));
    }

    public MetricsWebFilter(MeterRegistry registry, WebFluxTagsProvider tagsProvider, String metricName, Autotime autotime) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
        this.autotime = autotime != null ? autotime : Autotime.disabled();
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.autotime.isEnabled()) {
            return chain.filter(exchange).compose(call -> this.filter(exchange, (Mono<Void>)call));
        }
        return chain.filter(exchange);
    }

    private Publisher<Void> filter(ServerWebExchange exchange, Mono<Void> call) {
        long start = System.nanoTime();
        ServerHttpResponse response = exchange.getResponse();
        return call.doOnSuccess(done -> this.record(exchange, start, null)).doOnError(cause -> {
            if (response.isCommitted()) {
                this.record(exchange, start, (Throwable)cause);
            } else {
                response.beforeCommit(() -> {
                    this.record(exchange, start, (Throwable)cause);
                    return Mono.empty();
                });
            }
        });
    }

    private void record(ServerWebExchange exchange, long start, Throwable cause) {
        Iterable<Tag> tags = this.tagsProvider.httpRequestTags(exchange, cause);
        Timer.builder((String)this.metricName).tags(tags).publishPercentiles(this.autotime.getPercentiles()).publishPercentileHistogram(Boolean.valueOf(this.autotime.isPercentilesHistogram())).register(this.registry).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }
}

